<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRateType StructType
 * @subpackage Structs
 */
class RoomRateType extends AbstractStructBase
{
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RoomCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $RoomCode;
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RatesType
     */
    public $Rates;
    /**
     * The PromotionalCode
     * @var string
     */
    public $PromotionalCode;
    /**
     * The SpecialOfferID
     * @var int
     */
    public $SpecialOfferID;
    /**
     * The TotalAmountAfterTax
     * @var float
     */
    public $TotalAmountAfterTax;
    /**
     * Constructor method for RoomRateType
     * @uses RoomRateType::setRatePlanCode()
     * @uses RoomRateType::setRoomCode()
     * @uses RoomRateType::setRates()
     * @uses RoomRateType::setPromotionalCode()
     * @uses RoomRateType::setSpecialOfferID()
     * @uses RoomRateType::setTotalAmountAfterTax()
     * @param string $ratePlanCode
     * @param string $roomCode
     * @param \room\StructType\RatesType $rates
     * @param string $promotionalCode
     * @param int $specialOfferID
     * @param float $totalAmountAfterTax
     */
    public function __construct($ratePlanCode = null, $roomCode = null, \room\StructType\RatesType $rates = null, $promotionalCode = null, $specialOfferID = null, $totalAmountAfterTax = null)
    {
        $this
            ->setRatePlanCode($ratePlanCode)
            ->setRoomCode($roomCode)
            ->setRates($rates)
            ->setPromotionalCode($promotionalCode)
            ->setSpecialOfferID($specialOfferID)
            ->setTotalAmountAfterTax($totalAmountAfterTax);
    }
    /**
     * Get RatePlanCode value
     * @return string
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \room\StructType\RoomRateType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RoomCode value
     * @return string
     */
    public function getRoomCode()
    {
        return $this->RoomCode;
    }
    /**
     * Set RoomCode value
     * @param string $roomCode
     * @return \room\StructType\RoomRateType
     */
    public function setRoomCode($roomCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomCode) && !is_string($roomCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomCode, true), gettype($roomCode)), __LINE__);
        }
        $this->RoomCode = $roomCode;
        return $this;
    }
    /**
     * Get Rates value
     * @return \room\StructType\RatesType|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \room\StructType\RatesType $rates
     * @return \room\StructType\RoomRateType
     */
    public function setRates(\room\StructType\RatesType $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get PromotionalCode value
     * @return string|null
     */
    public function getPromotionalCode()
    {
        return $this->PromotionalCode;
    }
    /**
     * Set PromotionalCode value
     * @param string $promotionalCode
     * @return \room\StructType\RoomRateType
     */
    public function setPromotionalCode($promotionalCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionalCode) && !is_string($promotionalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionalCode, true), gettype($promotionalCode)), __LINE__);
        }
        $this->PromotionalCode = $promotionalCode;
        return $this;
    }
    /**
     * Get SpecialOfferID value
     * @return int|null
     */
    public function getSpecialOfferID()
    {
        return $this->SpecialOfferID;
    }
    /**
     * Set SpecialOfferID value
     * @param int $specialOfferID
     * @return \room\StructType\RoomRateType
     */
    public function setSpecialOfferID($specialOfferID = null)
    {
        // validation for constraint: int
        if (!is_null($specialOfferID) && !(is_int($specialOfferID) || ctype_digit($specialOfferID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($specialOfferID, true), gettype($specialOfferID)), __LINE__);
        }
        $this->SpecialOfferID = $specialOfferID;
        return $this;
    }
    /**
     * Get TotalAmountAfterTax value
     * @return float|null
     */
    public function getTotalAmountAfterTax()
    {
        return $this->TotalAmountAfterTax;
    }
    /**
     * Set TotalAmountAfterTax value
     * @param float $totalAmountAfterTax
     * @return \room\StructType\RoomRateType
     */
    public function setTotalAmountAfterTax($totalAmountAfterTax = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmountAfterTax) && !(is_float($totalAmountAfterTax) || is_numeric($totalAmountAfterTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmountAfterTax, true), gettype($totalAmountAfterTax)), __LINE__);
        }
        $this->TotalAmountAfterTax = $totalAmountAfterTax;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RoomRateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
