<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomCodesType StructType
 * @subpackage Structs
 */
class RoomCodesType extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $Code;
    /**
     * Constructor method for RoomCodesType
     * @uses RoomCodesType::setCode()
     * @param string[] $code
     */
    public function __construct(array $code = array())
    {
        $this
            ->setCode($code);
    }
    /**
     * Get Code value
     * @return string[]|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * This method is responsible for validating the values passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodeForArrayConstraintsFromSetCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomCodesTypeCodeItem) {
            // validation for constraint: itemType
            if (!is_string($roomCodesTypeCodeItem)) {
                $invalidValues[] = is_object($roomCodesTypeCodeItem) ? get_class($roomCodesTypeCodeItem) : sprintf('%s(%s)', gettype($roomCodesTypeCodeItem), var_export($roomCodesTypeCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Code property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Code value
     * @throws \InvalidArgumentException
     * @param string[] $code
     * @return \room\StructType\RoomCodesType
     */
    public function setCode(array $code = array())
    {
        // validation for constraint: array
        if ('' !== ($codeArrayErrorMessage = self::validateCodeForArrayConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeArrayErrorMessage, __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Add item to Code value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \room\StructType\RoomCodesType
     */
    public function addToCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Code property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Code[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RoomCodesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
