<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanType StructType
 * @subpackage Structs
 */
class RatePlanType extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The Descriptions
     * @var \room\StructType\DescriptionsType
     */
    public $Descriptions;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * The Category2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Category2;
    /**
     * The CommissionRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommissionRule;
    /**
     * The CancellationPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\CancellationPolicyType
     */
    public $CancellationPolicy;
    /**
     * The Meals
     * @var \room\StructType\MealsType
     */
    public $Meals;
    /**
     * The BoardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BoardType;
    /**
     * The OccupancyIncludesChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OccupancyIncludesChildren;
    /**
     * The OccupancyIncludesInfants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OccupancyIncludesInfants;
    /**
     * The ReservationMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReservationMode;
    /**
     * The ReservationDeadLineDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReservationDeadLineDays;
    /**
     * The ImageURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImageURL;
    /**
     * The PrePayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\PrePaymentType
     */
    public $PrePayment;
    /**
     * The MBROnlyRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MBROnlyRate;
    /**
     * Constructor method for RatePlanType
     * @uses RatePlanType::setCode()
     * @uses RatePlanType::setDescriptions()
     * @uses RatePlanType::setCategory()
     * @uses RatePlanType::setCategory2()
     * @uses RatePlanType::setCommissionRule()
     * @uses RatePlanType::setCancellationPolicy()
     * @uses RatePlanType::setMeals()
     * @uses RatePlanType::setBoardType()
     * @uses RatePlanType::setOccupancyIncludesChildren()
     * @uses RatePlanType::setOccupancyIncludesInfants()
     * @uses RatePlanType::setReservationMode()
     * @uses RatePlanType::setReservationDeadLineDays()
     * @uses RatePlanType::setImageURL()
     * @uses RatePlanType::setPrePayment()
     * @uses RatePlanType::setMBROnlyRate()
     * @param string $code
     * @param \room\StructType\DescriptionsType $descriptions
     * @param string $category
     * @param string $category2
     * @param string $commissionRule
     * @param \room\StructType\CancellationPolicyType $cancellationPolicy
     * @param \room\StructType\MealsType $meals
     * @param int $boardType
     * @param bool $occupancyIncludesChildren
     * @param bool $occupancyIncludesInfants
     * @param string $reservationMode
     * @param int $reservationDeadLineDays
     * @param string $imageURL
     * @param \room\StructType\PrePaymentType $prePayment
     * @param bool $mBROnlyRate
     */
    public function __construct($code = null, \room\StructType\DescriptionsType $descriptions = null, $category = null, $category2 = null, $commissionRule = null, \room\StructType\CancellationPolicyType $cancellationPolicy = null, \room\StructType\MealsType $meals = null, $boardType = null, $occupancyIncludesChildren = null, $occupancyIncludesInfants = null, $reservationMode = null, $reservationDeadLineDays = null, $imageURL = null, \room\StructType\PrePaymentType $prePayment = null, $mBROnlyRate = null)
    {
        $this
            ->setCode($code)
            ->setDescriptions($descriptions)
            ->setCategory($category)
            ->setCategory2($category2)
            ->setCommissionRule($commissionRule)
            ->setCancellationPolicy($cancellationPolicy)
            ->setMeals($meals)
            ->setBoardType($boardType)
            ->setOccupancyIncludesChildren($occupancyIncludesChildren)
            ->setOccupancyIncludesInfants($occupancyIncludesInfants)
            ->setReservationMode($reservationMode)
            ->setReservationDeadLineDays($reservationDeadLineDays)
            ->setImageURL($imageURL)
            ->setPrePayment($prePayment)
            ->setMBROnlyRate($mBROnlyRate);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \room\StructType\RatePlanType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \room\StructType\DescriptionsType|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \room\StructType\DescriptionsType $descriptions
     * @return \room\StructType\RatePlanType
     */
    public function setDescriptions(\room\StructType\DescriptionsType $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \room\StructType\RatePlanType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Category2 value
     * @return string|null
     */
    public function getCategory2()
    {
        return $this->Category2;
    }
    /**
     * Set Category2 value
     * @param string $category2
     * @return \room\StructType\RatePlanType
     */
    public function setCategory2($category2 = null)
    {
        // validation for constraint: string
        if (!is_null($category2) && !is_string($category2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category2, true), gettype($category2)), __LINE__);
        }
        $this->Category2 = $category2;
        return $this;
    }
    /**
     * Get CommissionRule value
     * @return string|null
     */
    public function getCommissionRule()
    {
        return $this->CommissionRule;
    }
    /**
     * Set CommissionRule value
     * @param string $commissionRule
     * @return \room\StructType\RatePlanType
     */
    public function setCommissionRule($commissionRule = null)
    {
        // validation for constraint: string
        if (!is_null($commissionRule) && !is_string($commissionRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commissionRule, true), gettype($commissionRule)), __LINE__);
        }
        $this->CommissionRule = $commissionRule;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \room\StructType\CancellationPolicyType|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \room\StructType\CancellationPolicyType $cancellationPolicy
     * @return \room\StructType\RatePlanType
     */
    public function setCancellationPolicy(\room\StructType\CancellationPolicyType $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get Meals value
     * @return \room\StructType\MealsType|null
     */
    public function getMeals()
    {
        return $this->Meals;
    }
    /**
     * Set Meals value
     * @param \room\StructType\MealsType $meals
     * @return \room\StructType\RatePlanType
     */
    public function setMeals(\room\StructType\MealsType $meals = null)
    {
        $this->Meals = $meals;
        return $this;
    }
    /**
     * Get BoardType value
     * @return int|null
     */
    public function getBoardType()
    {
        return $this->BoardType;
    }
    /**
     * Set BoardType value
     * @param int $boardType
     * @return \room\StructType\RatePlanType
     */
    public function setBoardType($boardType = null)
    {
        // validation for constraint: int
        if (!is_null($boardType) && !(is_int($boardType) || ctype_digit($boardType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boardType, true), gettype($boardType)), __LINE__);
        }
        $this->BoardType = $boardType;
        return $this;
    }
    /**
     * Get OccupancyIncludesChildren value
     * @return bool|null
     */
    public function getOccupancyIncludesChildren()
    {
        return $this->OccupancyIncludesChildren;
    }
    /**
     * Set OccupancyIncludesChildren value
     * @param bool $occupancyIncludesChildren
     * @return \room\StructType\RatePlanType
     */
    public function setOccupancyIncludesChildren($occupancyIncludesChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($occupancyIncludesChildren) && !is_bool($occupancyIncludesChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($occupancyIncludesChildren, true), gettype($occupancyIncludesChildren)), __LINE__);
        }
        $this->OccupancyIncludesChildren = $occupancyIncludesChildren;
        return $this;
    }
    /**
     * Get OccupancyIncludesInfants value
     * @return bool|null
     */
    public function getOccupancyIncludesInfants()
    {
        return $this->OccupancyIncludesInfants;
    }
    /**
     * Set OccupancyIncludesInfants value
     * @param bool $occupancyIncludesInfants
     * @return \room\StructType\RatePlanType
     */
    public function setOccupancyIncludesInfants($occupancyIncludesInfants = null)
    {
        // validation for constraint: boolean
        if (!is_null($occupancyIncludesInfants) && !is_bool($occupancyIncludesInfants)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($occupancyIncludesInfants, true), gettype($occupancyIncludesInfants)), __LINE__);
        }
        $this->OccupancyIncludesInfants = $occupancyIncludesInfants;
        return $this;
    }
    /**
     * Get ReservationMode value
     * @return string|null
     */
    public function getReservationMode()
    {
        return $this->ReservationMode;
    }
    /**
     * Set ReservationMode value
     * @param string $reservationMode
     * @return \room\StructType\RatePlanType
     */
    public function setReservationMode($reservationMode = null)
    {
        // validation for constraint: string
        if (!is_null($reservationMode) && !is_string($reservationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationMode, true), gettype($reservationMode)), __LINE__);
        }
        $this->ReservationMode = $reservationMode;
        return $this;
    }
    /**
     * Get ReservationDeadLineDays value
     * @return int|null
     */
    public function getReservationDeadLineDays()
    {
        return $this->ReservationDeadLineDays;
    }
    /**
     * Set ReservationDeadLineDays value
     * @param int $reservationDeadLineDays
     * @return \room\StructType\RatePlanType
     */
    public function setReservationDeadLineDays($reservationDeadLineDays = null)
    {
        // validation for constraint: int
        if (!is_null($reservationDeadLineDays) && !(is_int($reservationDeadLineDays) || ctype_digit($reservationDeadLineDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationDeadLineDays, true), gettype($reservationDeadLineDays)), __LINE__);
        }
        $this->ReservationDeadLineDays = $reservationDeadLineDays;
        return $this;
    }
    /**
     * Get ImageURL value
     * @return string|null
     */
    public function getImageURL()
    {
        return $this->ImageURL;
    }
    /**
     * Set ImageURL value
     * @param string $imageURL
     * @return \room\StructType\RatePlanType
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageURL, true), gettype($imageURL)), __LINE__);
        }
        $this->ImageURL = $imageURL;
        return $this;
    }
    /**
     * Get PrePayment value
     * @return \room\StructType\PrePaymentType|null
     */
    public function getPrePayment()
    {
        return $this->PrePayment;
    }
    /**
     * Set PrePayment value
     * @param \room\StructType\PrePaymentType $prePayment
     * @return \room\StructType\RatePlanType
     */
    public function setPrePayment(\room\StructType\PrePaymentType $prePayment = null)
    {
        $this->PrePayment = $prePayment;
        return $this;
    }
    /**
     * Get MBROnlyRate value
     * @return bool|null
     */
    public function getMBROnlyRate()
    {
        return $this->MBROnlyRate;
    }
    /**
     * Set MBROnlyRate value
     * @param bool $mBROnlyRate
     * @return \room\StructType\RatePlanType
     */
    public function setMBROnlyRate($mBROnlyRate = null)
    {
        // validation for constraint: boolean
        if (!is_null($mBROnlyRate) && !is_bool($mBROnlyRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mBROnlyRate, true), gettype($mBROnlyRate)), __LINE__);
        }
        $this->MBROnlyRate = $mBROnlyRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RatePlanType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
