<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfilesType StructType
 * @subpackage Structs
 */
class ProfilesType extends AbstractStructBase
{
    /**
     * The Profile
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \room\StructType\ProfileType[]
     */
    public $Profile;
    /**
     * Constructor method for ProfilesType
     * @uses ProfilesType::setProfile()
     * @param \room\StructType\ProfileType[] $profile
     */
    public function __construct(array $profile = array())
    {
        $this
            ->setProfile($profile);
    }
    /**
     * Get Profile value
     * @return \room\StructType\ProfileType[]|null
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * This method is responsible for validating the values passed to the setProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileForArrayConstraintsFromSetProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profilesTypeProfileItem) {
            // validation for constraint: itemType
            if (!$profilesTypeProfileItem instanceof \room\StructType\ProfileType) {
                $invalidValues[] = is_object($profilesTypeProfileItem) ? get_class($profilesTypeProfileItem) : sprintf('%s(%s)', gettype($profilesTypeProfileItem), var_export($profilesTypeProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Profile property can only contain items of type \room\StructType\ProfileType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Profile value
     * @throws \InvalidArgumentException
     * @param \room\StructType\ProfileType[] $profile
     * @return \room\StructType\ProfilesType
     */
    public function setProfile(array $profile = array())
    {
        // validation for constraint: array
        if ('' !== ($profileArrayErrorMessage = self::validateProfileForArrayConstraintsFromSetProfile($profile))) {
            throw new \InvalidArgumentException($profileArrayErrorMessage, __LINE__);
        }
        $this->Profile = $profile;
        return $this;
    }
    /**
     * Add item to Profile value
     * @throws \InvalidArgumentException
     * @param \room\StructType\ProfileType $item
     * @return \room\StructType\ProfilesType
     */
    public function addToProfile(\room\StructType\ProfileType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\ProfileType) {
            throw new \InvalidArgumentException(sprintf('The Profile property can only contain items of type \room\StructType\ProfileType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Profile[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\ProfilesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
