<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrePaymentType StructType
 * @subpackage Structs
 */
class PrePaymentType extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The isPercentage
     * @var bool
     */
    public $isPercentage;
    /**
     * The Value
     * @var float
     */
    public $Value;
    /**
     * Constructor method for PrePaymentType
     * @uses PrePaymentType::setType()
     * @uses PrePaymentType::setIsPercentage()
     * @uses PrePaymentType::setValue()
     * @param string $type
     * @param bool $isPercentage
     * @param float $value
     */
    public function __construct($type = null, $isPercentage = null, $value = null)
    {
        $this
            ->setType($type)
            ->setIsPercentage($isPercentage)
            ->setValue($value);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \room\EnumType\PrePaymentTypeType::valueIsValid()
     * @uses \room\EnumType\PrePaymentTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \room\StructType\PrePaymentType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\room\EnumType\PrePaymentTypeType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \room\EnumType\PrePaymentTypeType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \room\EnumType\PrePaymentTypeType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get isPercentage value
     * @return bool|null
     */
    public function getIsPercentage()
    {
        return $this->isPercentage;
    }
    /**
     * Set isPercentage value
     * @param bool $isPercentage
     * @return \room\StructType\PrePaymentType
     */
    public function setIsPercentage($isPercentage = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPercentage) && !is_bool($isPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPercentage, true), gettype($isPercentage)), __LINE__);
        }
        $this->isPercentage = $isPercentage;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \room\StructType\PrePaymentType
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\PrePaymentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
