<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Meal StructType
 * @subpackage Structs
 */
class Meal extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Price;
    /**
     * The IncludedInPrice
     * @var bool
     */
    public $IncludedInPrice;
    /**
     * Constructor method for Meal
     * @uses Meal::setType()
     * @uses Meal::setName()
     * @uses Meal::setPrice()
     * @uses Meal::setIncludedInPrice()
     * @param string $type
     * @param string $name
     * @param float $price
     * @param bool $includedInPrice
     */
    public function __construct($type = null, $name = null, $price = null, $includedInPrice = null)
    {
        $this
            ->setType($type)
            ->setName($name)
            ->setPrice($price)
            ->setIncludedInPrice($includedInPrice);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \room\StructType\Meal
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \room\StructType\Meal
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \room\StructType\Meal
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get IncludedInPrice value
     * @return bool|null
     */
    public function getIncludedInPrice()
    {
        return $this->IncludedInPrice;
    }
    /**
     * Set IncludedInPrice value
     * @param bool $includedInPrice
     * @return \room\StructType\Meal
     */
    public function setIncludedInPrice($includedInPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($includedInPrice) && !is_bool($includedInPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includedInPrice, true), gettype($includedInPrice)), __LINE__);
        }
        $this->IncludedInPrice = $includedInPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\Meal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
