<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeReservationRS StructType
 * @subpackage Structs
 */
class MakeReservationRS extends ResponseType
{
    /**
     * The ResultCode
     * @var string
     */
    public $ResultCode;
    /**
     * The CRSConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CRSConfirmationNumber;
    /**
     * The PMSConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PMSConfirmationNumber;
    /**
     * The KeyCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \room\StructType\AccessCodeItem[]
     */
    public $KeyCodes;
    /**
     * The KeyCodesStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $KeyCodesStatus;
    /**
     * Constructor method for MakeReservationRS
     * @uses MakeReservationRS::setResultCode()
     * @uses MakeReservationRS::setCRSConfirmationNumber()
     * @uses MakeReservationRS::setPMSConfirmationNumber()
     * @uses MakeReservationRS::setKeyCodes()
     * @uses MakeReservationRS::setKeyCodesStatus()
     * @param string $resultCode
     * @param string $cRSConfirmationNumber
     * @param string $pMSConfirmationNumber
     * @param \room\StructType\AccessCodeItem[] $keyCodes
     * @param string $keyCodesStatus
     */
    public function __construct($resultCode = null, $cRSConfirmationNumber = null, $pMSConfirmationNumber = null, array $keyCodes = array(), $keyCodesStatus = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setCRSConfirmationNumber($cRSConfirmationNumber)
            ->setPMSConfirmationNumber($pMSConfirmationNumber)
            ->setKeyCodes($keyCodes)
            ->setKeyCodesStatus($keyCodesStatus);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \room\StructType\MakeReservationRS
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get CRSConfirmationNumber value
     * @return string|null
     */
    public function getCRSConfirmationNumber()
    {
        return $this->CRSConfirmationNumber;
    }
    /**
     * Set CRSConfirmationNumber value
     * @param string $cRSConfirmationNumber
     * @return \room\StructType\MakeReservationRS
     */
    public function setCRSConfirmationNumber($cRSConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cRSConfirmationNumber) && !is_string($cRSConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cRSConfirmationNumber, true), gettype($cRSConfirmationNumber)), __LINE__);
        }
        $this->CRSConfirmationNumber = $cRSConfirmationNumber;
        return $this;
    }
    /**
     * Get PMSConfirmationNumber value
     * @return string|null
     */
    public function getPMSConfirmationNumber()
    {
        return $this->PMSConfirmationNumber;
    }
    /**
     * Set PMSConfirmationNumber value
     * @param string $pMSConfirmationNumber
     * @return \room\StructType\MakeReservationRS
     */
    public function setPMSConfirmationNumber($pMSConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pMSConfirmationNumber) && !is_string($pMSConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pMSConfirmationNumber, true), gettype($pMSConfirmationNumber)), __LINE__);
        }
        $this->PMSConfirmationNumber = $pMSConfirmationNumber;
        return $this;
    }
    /**
     * Get KeyCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \room\StructType\AccessCodeItem[]|null
     */
    public function getKeyCodes()
    {
        return isset($this->KeyCodes) ? $this->KeyCodes : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKeyCodes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyCodes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeyCodesForArrayConstraintsFromSetKeyCodes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $makeReservationRSKeyCodesItem) {
            // validation for constraint: itemType
            if (!$makeReservationRSKeyCodesItem instanceof \room\StructType\AccessCodeItem) {
                $invalidValues[] = is_object($makeReservationRSKeyCodesItem) ? get_class($makeReservationRSKeyCodesItem) : sprintf('%s(%s)', gettype($makeReservationRSKeyCodesItem), var_export($makeReservationRSKeyCodesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KeyCodes property can only contain items of type \room\StructType\AccessCodeItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KeyCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \room\StructType\AccessCodeItem[] $keyCodes
     * @return \room\StructType\MakeReservationRS
     */
    public function setKeyCodes(array $keyCodes = array())
    {
        // validation for constraint: array
        if ('' !== ($keyCodesArrayErrorMessage = self::validateKeyCodesForArrayConstraintsFromSetKeyCodes($keyCodes))) {
            throw new \InvalidArgumentException($keyCodesArrayErrorMessage, __LINE__);
        }
        if (is_null($keyCodes) || (is_array($keyCodes) && empty($keyCodes))) {
            unset($this->KeyCodes);
        } else {
            $this->KeyCodes = $keyCodes;
        }
        return $this;
    }
    /**
     * Add item to KeyCodes value
     * @throws \InvalidArgumentException
     * @param \room\StructType\AccessCodeItem $item
     * @return \room\StructType\MakeReservationRS
     */
    public function addToKeyCodes(\room\StructType\AccessCodeItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\AccessCodeItem) {
            throw new \InvalidArgumentException(sprintf('The KeyCodes property can only contain items of type \room\StructType\AccessCodeItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KeyCodes[] = $item;
        return $this;
    }
    /**
     * Get KeyCodesStatus value
     * @return string|null
     */
    public function getKeyCodesStatus()
    {
        return $this->KeyCodesStatus;
    }
    /**
     * Set KeyCodesStatus value
     * @param string $keyCodesStatus
     * @return \room\StructType\MakeReservationRS
     */
    public function setKeyCodesStatus($keyCodesStatus = null)
    {
        // validation for constraint: string
        if (!is_null($keyCodesStatus) && !is_string($keyCodesStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyCodesStatus, true), gettype($keyCodesStatus)), __LINE__);
        }
        $this->KeyCodesStatus = $keyCodesStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\MakeReservationRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
