<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelDetailsType StructType
 * @subpackage Structs
 */
class HotelDetailsType extends AbstractStructBase
{
    /**
     * The HotelCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $HotelCode;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Description
     * @var \room\StructType\DescriptionType
     */
    public $Description;
    /**
     * The Rating
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RatingType
     */
    public $Rating;
    /**
     * The Position
     * @var \room\StructType\PositionType
     */
    public $Position;
    /**
     * The Address
     * @var \room\StructType\AddressType
     */
    public $Address;
    /**
     * The Directions
     * @var \room\StructType\DescriptionType
     */
    public $Directions;
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\FeaturesType
     */
    public $Features;
    /**
     * The Rules
     * @var \room\StructType\RulesType
     */
    public $Rules;
    /**
     * The Meals
     * @var \room\StructType\MealsType
     */
    public $Meals;
    /**
     * The HotelImages
     * @var \room\StructType\HotelImagesType
     */
    public $HotelImages;
    /**
     * The General
     * @var \room\StructType\DescriptionType
     */
    public $General;
    /**
     * The Activities
     * @var \room\StructType\DescriptionType
     */
    public $Activities;
    /**
     * The Parking
     * @var \room\StructType\DescriptionType
     */
    public $Parking;
    /**
     * The Rooms
     * @var \room\StructType\DescriptionType
     */
    public $Rooms;
    /**
     * The UserDef1
     * @var \room\StructType\DescriptionType
     */
    public $UserDef1;
    /**
     * The UserDef2
     * @var \room\StructType\DescriptionType
     */
    public $UserDef2;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * Constructor method for HotelDetailsType
     * @uses HotelDetailsType::setHotelCode()
     * @uses HotelDetailsType::setName()
     * @uses HotelDetailsType::setDescription()
     * @uses HotelDetailsType::setRating()
     * @uses HotelDetailsType::setPosition()
     * @uses HotelDetailsType::setAddress()
     * @uses HotelDetailsType::setDirections()
     * @uses HotelDetailsType::setFeatures()
     * @uses HotelDetailsType::setRules()
     * @uses HotelDetailsType::setMeals()
     * @uses HotelDetailsType::setHotelImages()
     * @uses HotelDetailsType::setGeneral()
     * @uses HotelDetailsType::setActivities()
     * @uses HotelDetailsType::setParking()
     * @uses HotelDetailsType::setRooms()
     * @uses HotelDetailsType::setUserDef1()
     * @uses HotelDetailsType::setUserDef2()
     * @uses HotelDetailsType::setTelephone()
     * @uses HotelDetailsType::setEmail()
     * @param string $hotelCode
     * @param string $name
     * @param \room\StructType\DescriptionType $description
     * @param \room\StructType\RatingType $rating
     * @param \room\StructType\PositionType $position
     * @param \room\StructType\AddressType $address
     * @param \room\StructType\DescriptionType $directions
     * @param \room\StructType\FeaturesType $features
     * @param \room\StructType\RulesType $rules
     * @param \room\StructType\MealsType $meals
     * @param \room\StructType\HotelImagesType $hotelImages
     * @param \room\StructType\DescriptionType $general
     * @param \room\StructType\DescriptionType $activities
     * @param \room\StructType\DescriptionType $parking
     * @param \room\StructType\DescriptionType $rooms
     * @param \room\StructType\DescriptionType $userDef1
     * @param \room\StructType\DescriptionType $userDef2
     * @param string $telephone
     * @param string $email
     */
    public function __construct($hotelCode = null, $name = null, \room\StructType\DescriptionType $description = null, \room\StructType\RatingType $rating = null, \room\StructType\PositionType $position = null, \room\StructType\AddressType $address = null, \room\StructType\DescriptionType $directions = null, \room\StructType\FeaturesType $features = null, \room\StructType\RulesType $rules = null, \room\StructType\MealsType $meals = null, \room\StructType\HotelImagesType $hotelImages = null, \room\StructType\DescriptionType $general = null, \room\StructType\DescriptionType $activities = null, \room\StructType\DescriptionType $parking = null, \room\StructType\DescriptionType $rooms = null, \room\StructType\DescriptionType $userDef1 = null, \room\StructType\DescriptionType $userDef2 = null, $telephone = null, $email = null)
    {
        $this
            ->setHotelCode($hotelCode)
            ->setName($name)
            ->setDescription($description)
            ->setRating($rating)
            ->setPosition($position)
            ->setAddress($address)
            ->setDirections($directions)
            ->setFeatures($features)
            ->setRules($rules)
            ->setMeals($meals)
            ->setHotelImages($hotelImages)
            ->setGeneral($general)
            ->setActivities($activities)
            ->setParking($parking)
            ->setRooms($rooms)
            ->setUserDef1($userDef1)
            ->setUserDef2($userDef2)
            ->setTelephone($telephone)
            ->setEmail($email);
    }
    /**
     * Get HotelCode value
     * @return string
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \room\StructType\HotelDetailsType
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \room\StructType\HotelDetailsType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return \room\StructType\DescriptionType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \room\StructType\DescriptionType $description
     * @return \room\StructType\HotelDetailsType
     */
    public function setDescription(\room\StructType\DescriptionType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Rating value
     * @return \room\StructType\RatingType|null
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @param \room\StructType\RatingType $rating
     * @return \room\StructType\HotelDetailsType
     */
    public function setRating(\room\StructType\RatingType $rating = null)
    {
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Get Position value
     * @return \room\StructType\PositionType|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \room\StructType\PositionType $position
     * @return \room\StructType\HotelDetailsType
     */
    public function setPosition(\room\StructType\PositionType $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Address value
     * @return \room\StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \room\StructType\AddressType $address
     * @return \room\StructType\HotelDetailsType
     */
    public function setAddress(\room\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Directions value
     * @return \room\StructType\DescriptionType|null
     */
    public function getDirections()
    {
        return $this->Directions;
    }
    /**
     * Set Directions value
     * @param \room\StructType\DescriptionType $directions
     * @return \room\StructType\HotelDetailsType
     */
    public function setDirections(\room\StructType\DescriptionType $directions = null)
    {
        $this->Directions = $directions;
        return $this;
    }
    /**
     * Get Features value
     * @return \room\StructType\FeaturesType|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \room\StructType\FeaturesType $features
     * @return \room\StructType\HotelDetailsType
     */
    public function setFeatures(\room\StructType\FeaturesType $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get Rules value
     * @return \room\StructType\RulesType|null
     */
    public function getRules()
    {
        return $this->Rules;
    }
    /**
     * Set Rules value
     * @param \room\StructType\RulesType $rules
     * @return \room\StructType\HotelDetailsType
     */
    public function setRules(\room\StructType\RulesType $rules = null)
    {
        $this->Rules = $rules;
        return $this;
    }
    /**
     * Get Meals value
     * @return \room\StructType\MealsType|null
     */
    public function getMeals()
    {
        return $this->Meals;
    }
    /**
     * Set Meals value
     * @param \room\StructType\MealsType $meals
     * @return \room\StructType\HotelDetailsType
     */
    public function setMeals(\room\StructType\MealsType $meals = null)
    {
        $this->Meals = $meals;
        return $this;
    }
    /**
     * Get HotelImages value
     * @return \room\StructType\HotelImagesType|null
     */
    public function getHotelImages()
    {
        return $this->HotelImages;
    }
    /**
     * Set HotelImages value
     * @param \room\StructType\HotelImagesType $hotelImages
     * @return \room\StructType\HotelDetailsType
     */
    public function setHotelImages(\room\StructType\HotelImagesType $hotelImages = null)
    {
        $this->HotelImages = $hotelImages;
        return $this;
    }
    /**
     * Get General value
     * @return \room\StructType\DescriptionType|null
     */
    public function getGeneral()
    {
        return $this->General;
    }
    /**
     * Set General value
     * @param \room\StructType\DescriptionType $general
     * @return \room\StructType\HotelDetailsType
     */
    public function setGeneral(\room\StructType\DescriptionType $general = null)
    {
        $this->General = $general;
        return $this;
    }
    /**
     * Get Activities value
     * @return \room\StructType\DescriptionType|null
     */
    public function getActivities()
    {
        return $this->Activities;
    }
    /**
     * Set Activities value
     * @param \room\StructType\DescriptionType $activities
     * @return \room\StructType\HotelDetailsType
     */
    public function setActivities(\room\StructType\DescriptionType $activities = null)
    {
        $this->Activities = $activities;
        return $this;
    }
    /**
     * Get Parking value
     * @return \room\StructType\DescriptionType|null
     */
    public function getParking()
    {
        return $this->Parking;
    }
    /**
     * Set Parking value
     * @param \room\StructType\DescriptionType $parking
     * @return \room\StructType\HotelDetailsType
     */
    public function setParking(\room\StructType\DescriptionType $parking = null)
    {
        $this->Parking = $parking;
        return $this;
    }
    /**
     * Get Rooms value
     * @return \room\StructType\DescriptionType|null
     */
    public function getRooms()
    {
        return $this->Rooms;
    }
    /**
     * Set Rooms value
     * @param \room\StructType\DescriptionType $rooms
     * @return \room\StructType\HotelDetailsType
     */
    public function setRooms(\room\StructType\DescriptionType $rooms = null)
    {
        $this->Rooms = $rooms;
        return $this;
    }
    /**
     * Get UserDef1 value
     * @return \room\StructType\DescriptionType|null
     */
    public function getUserDef1()
    {
        return $this->UserDef1;
    }
    /**
     * Set UserDef1 value
     * @param \room\StructType\DescriptionType $userDef1
     * @return \room\StructType\HotelDetailsType
     */
    public function setUserDef1(\room\StructType\DescriptionType $userDef1 = null)
    {
        $this->UserDef1 = $userDef1;
        return $this;
    }
    /**
     * Get UserDef2 value
     * @return \room\StructType\DescriptionType|null
     */
    public function getUserDef2()
    {
        return $this->UserDef2;
    }
    /**
     * Set UserDef2 value
     * @param \room\StructType\DescriptionType $userDef2
     * @return \room\StructType\HotelDetailsType
     */
    public function setUserDef2(\room\StructType\DescriptionType $userDef2 = null)
    {
        $this->UserDef2 = $userDef2;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \room\StructType\HotelDetailsType
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \room\StructType\HotelDetailsType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\HotelDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
