<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProfileV2RQ StructType
 * @subpackage Structs
 */
class GetProfileV2RQ extends AbstractStructBase
{
    /**
     * The HotelRef
     * @var \room\StructType\HotelRefType
     */
    public $HotelRef;
    /**
     * The Email
     * @var string
     */
    public $Email;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The Surname
     * @var string
     */
    public $Surname;
    /**
     * The Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The Lang
     * @var string
     */
    public $Lang;
    /**
     * The Debug
     * @var bool
     */
    public $Debug;
    /**
     * Constructor method for GetProfileV2RQ
     * @uses GetProfileV2RQ::setHotelRef()
     * @uses GetProfileV2RQ::setEmail()
     * @uses GetProfileV2RQ::setPassword()
     * @uses GetProfileV2RQ::setSurname()
     * @uses GetProfileV2RQ::setTimestamp()
     * @uses GetProfileV2RQ::setVersion()
     * @uses GetProfileV2RQ::setLang()
     * @uses GetProfileV2RQ::setDebug()
     * @param \room\StructType\HotelRefType $hotelRef
     * @param string $email
     * @param string $password
     * @param string $surname
     * @param string $timestamp
     * @param float $version
     * @param string $lang
     * @param bool $debug
     */
    public function __construct(\room\StructType\HotelRefType $hotelRef = null, $email = null, $password = null, $surname = null, $timestamp = null, $version = null, $lang = null, $debug = null)
    {
        $this
            ->setHotelRef($hotelRef)
            ->setEmail($email)
            ->setPassword($password)
            ->setSurname($surname)
            ->setTimestamp($timestamp)
            ->setVersion($version)
            ->setLang($lang)
            ->setDebug($debug);
    }
    /**
     * Get HotelRef value
     * @return \room\StructType\HotelRefType|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \room\StructType\HotelRefType $hotelRef
     * @return \room\StructType\GetProfileV2RQ
     */
    public function setHotelRef(\room\StructType\HotelRefType $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \room\StructType\GetProfileV2RQ
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \room\StructType\GetProfileV2RQ
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \room\StructType\GetProfileV2RQ
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \room\StructType\GetProfileV2RQ
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \room\StructType\GetProfileV2RQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->Lang;
    }
    /**
     * Set Lang value
     * @param string $lang
     * @return \room\StructType\GetProfileV2RQ
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->Lang = $lang;
        return $this;
    }
    /**
     * Get Debug value
     * @return bool|null
     */
    public function getDebug()
    {
        return $this->Debug;
    }
    /**
     * Set Debug value
     * @param bool $debug
     * @return \room\StructType\GetProfileV2RQ
     */
    public function setDebug($debug = null)
    {
        // validation for constraint: boolean
        if (!is_null($debug) && !is_bool($debug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($debug, true), gettype($debug)), __LINE__);
        }
        $this->Debug = $debug;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\GetProfileV2RQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
