<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailabilityRS StructType
 * @subpackage Structs
 */
class GetAvailabilityRS extends ResponseType
{
    /**
     * The ResultCode
     * @var string
     */
    public $ResultCode;
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\HotelRefType
     */
    public $HotelRef;
    /**
     * The Prepaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Prepaid;
    /**
     * The AvailableRoomRates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\AvailableRoomRatesType
     */
    public $AvailableRoomRates;
    /**
     * The DailyAvailabilities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DailyAvailabilitiesType
     */
    public $DailyAvailabilities;
    /**
     * The RoomsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RoomsType
     */
    public $RoomsInfo;
    /**
     * The RatePlansInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RatePlansType
     */
    public $RatePlansInfo;
    /**
     * Constructor method for GetAvailabilityRS
     * @uses GetAvailabilityRS::setResultCode()
     * @uses GetAvailabilityRS::setHotelRef()
     * @uses GetAvailabilityRS::setPrepaid()
     * @uses GetAvailabilityRS::setAvailableRoomRates()
     * @uses GetAvailabilityRS::setDailyAvailabilities()
     * @uses GetAvailabilityRS::setRoomsInfo()
     * @uses GetAvailabilityRS::setRatePlansInfo()
     * @param string $resultCode
     * @param \room\StructType\HotelRefType $hotelRef
     * @param bool $prepaid
     * @param \room\StructType\AvailableRoomRatesType $availableRoomRates
     * @param \room\StructType\DailyAvailabilitiesType $dailyAvailabilities
     * @param \room\StructType\RoomsType $roomsInfo
     * @param \room\StructType\RatePlansType $ratePlansInfo
     */
    public function __construct($resultCode = null, \room\StructType\HotelRefType $hotelRef = null, $prepaid = null, \room\StructType\AvailableRoomRatesType $availableRoomRates = null, \room\StructType\DailyAvailabilitiesType $dailyAvailabilities = null, \room\StructType\RoomsType $roomsInfo = null, \room\StructType\RatePlansType $ratePlansInfo = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setHotelRef($hotelRef)
            ->setPrepaid($prepaid)
            ->setAvailableRoomRates($availableRoomRates)
            ->setDailyAvailabilities($dailyAvailabilities)
            ->setRoomsInfo($roomsInfo)
            ->setRatePlansInfo($ratePlansInfo);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \room\StructType\GetAvailabilityRS
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get HotelRef value
     * @return \room\StructType\HotelRefType|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \room\StructType\HotelRefType $hotelRef
     * @return \room\StructType\GetAvailabilityRS
     */
    public function setHotelRef(\room\StructType\HotelRefType $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get Prepaid value
     * @return bool|null
     */
    public function getPrepaid()
    {
        return $this->Prepaid;
    }
    /**
     * Set Prepaid value
     * @param bool $prepaid
     * @return \room\StructType\GetAvailabilityRS
     */
    public function setPrepaid($prepaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid) && !is_bool($prepaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaid, true), gettype($prepaid)), __LINE__);
        }
        $this->Prepaid = $prepaid;
        return $this;
    }
    /**
     * Get AvailableRoomRates value
     * @return \room\StructType\AvailableRoomRatesType|null
     */
    public function getAvailableRoomRates()
    {
        return $this->AvailableRoomRates;
    }
    /**
     * Set AvailableRoomRates value
     * @param \room\StructType\AvailableRoomRatesType $availableRoomRates
     * @return \room\StructType\GetAvailabilityRS
     */
    public function setAvailableRoomRates(\room\StructType\AvailableRoomRatesType $availableRoomRates = null)
    {
        $this->AvailableRoomRates = $availableRoomRates;
        return $this;
    }
    /**
     * Get DailyAvailabilities value
     * @return \room\StructType\DailyAvailabilitiesType|null
     */
    public function getDailyAvailabilities()
    {
        return $this->DailyAvailabilities;
    }
    /**
     * Set DailyAvailabilities value
     * @param \room\StructType\DailyAvailabilitiesType $dailyAvailabilities
     * @return \room\StructType\GetAvailabilityRS
     */
    public function setDailyAvailabilities(\room\StructType\DailyAvailabilitiesType $dailyAvailabilities = null)
    {
        $this->DailyAvailabilities = $dailyAvailabilities;
        return $this;
    }
    /**
     * Get RoomsInfo value
     * @return \room\StructType\RoomsType|null
     */
    public function getRoomsInfo()
    {
        return $this->RoomsInfo;
    }
    /**
     * Set RoomsInfo value
     * @param \room\StructType\RoomsType $roomsInfo
     * @return \room\StructType\GetAvailabilityRS
     */
    public function setRoomsInfo(\room\StructType\RoomsType $roomsInfo = null)
    {
        $this->RoomsInfo = $roomsInfo;
        return $this;
    }
    /**
     * Get RatePlansInfo value
     * @return \room\StructType\RatePlansType|null
     */
    public function getRatePlansInfo()
    {
        return $this->RatePlansInfo;
    }
    /**
     * Set RatePlansInfo value
     * @param \room\StructType\RatePlansType $ratePlansInfo
     * @return \room\StructType\GetAvailabilityRS
     */
    public function setRatePlansInfo(\room\StructType\RatePlansType $ratePlansInfo = null)
    {
        $this->RatePlansInfo = $ratePlansInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\GetAvailabilityRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
