<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailabilityRQ StructType
 * @subpackage Structs
 */
class GetAvailabilityRQ extends AbstractStructBase
{
    /**
     * The HotelRef
     * @var \room\StructType\HotelRefType
     */
    public $HotelRef;
    /**
     * The GuestCounts
     * @var \room\StructType\GuestCountsType
     */
    public $GuestCounts;
    /**
     * The StayDateRange
     * @var \room\StructType\StayDateRangeType
     */
    public $StayDateRange;
    /**
     * The RatePlanCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RatePlanCodesType
     */
    public $RatePlanCodes;
    /**
     * The PromotionalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\PromotionalCode
     */
    public $PromotionalCode;
    /**
     * The RateCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RateCategory;
    /**
     * The RoomCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RoomCodesType
     */
    public $RoomCodes;
    /**
     * The RoomBlockCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoomBlockCode;
    /**
     * The CompanyRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\CompanyRefType
     */
    public $CompanyRef;
    /**
     * The Mode
     * @var string
     */
    public $Mode;
    /**
     * The AddRoomRateInfo
     * @var bool
     */
    public $AddRoomRateInfo;
    /**
     * The Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The Lang
     * @var string
     */
    public $Lang;
    /**
     * The Debug
     * @var bool
     */
    public $Debug;
    /**
     * Constructor method for GetAvailabilityRQ
     * @uses GetAvailabilityRQ::setHotelRef()
     * @uses GetAvailabilityRQ::setGuestCounts()
     * @uses GetAvailabilityRQ::setStayDateRange()
     * @uses GetAvailabilityRQ::setRatePlanCodes()
     * @uses GetAvailabilityRQ::setPromotionalCode()
     * @uses GetAvailabilityRQ::setRateCategory()
     * @uses GetAvailabilityRQ::setRoomCodes()
     * @uses GetAvailabilityRQ::setRoomBlockCode()
     * @uses GetAvailabilityRQ::setCompanyRef()
     * @uses GetAvailabilityRQ::setMode()
     * @uses GetAvailabilityRQ::setAddRoomRateInfo()
     * @uses GetAvailabilityRQ::setTimestamp()
     * @uses GetAvailabilityRQ::setVersion()
     * @uses GetAvailabilityRQ::setLang()
     * @uses GetAvailabilityRQ::setDebug()
     * @param \room\StructType\HotelRefType $hotelRef
     * @param \room\StructType\GuestCountsType $guestCounts
     * @param \room\StructType\StayDateRangeType $stayDateRange
     * @param \room\StructType\RatePlanCodesType $ratePlanCodes
     * @param \room\StructType\PromotionalCode $promotionalCode
     * @param string $rateCategory
     * @param \room\StructType\RoomCodesType $roomCodes
     * @param string $roomBlockCode
     * @param \room\StructType\CompanyRefType $companyRef
     * @param string $mode
     * @param bool $addRoomRateInfo
     * @param string $timestamp
     * @param float $version
     * @param string $lang
     * @param bool $debug
     */
    public function __construct(\room\StructType\HotelRefType $hotelRef = null, \room\StructType\GuestCountsType $guestCounts = null, \room\StructType\StayDateRangeType $stayDateRange = null, \room\StructType\RatePlanCodesType $ratePlanCodes = null, \room\StructType\PromotionalCode $promotionalCode = null, $rateCategory = null, \room\StructType\RoomCodesType $roomCodes = null, $roomBlockCode = null, \room\StructType\CompanyRefType $companyRef = null, $mode = null, $addRoomRateInfo = null, $timestamp = null, $version = null, $lang = null, $debug = null)
    {
        $this
            ->setHotelRef($hotelRef)
            ->setGuestCounts($guestCounts)
            ->setStayDateRange($stayDateRange)
            ->setRatePlanCodes($ratePlanCodes)
            ->setPromotionalCode($promotionalCode)
            ->setRateCategory($rateCategory)
            ->setRoomCodes($roomCodes)
            ->setRoomBlockCode($roomBlockCode)
            ->setCompanyRef($companyRef)
            ->setMode($mode)
            ->setAddRoomRateInfo($addRoomRateInfo)
            ->setTimestamp($timestamp)
            ->setVersion($version)
            ->setLang($lang)
            ->setDebug($debug);
    }
    /**
     * Get HotelRef value
     * @return \room\StructType\HotelRefType|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \room\StructType\HotelRefType $hotelRef
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setHotelRef(\room\StructType\HotelRefType $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \room\StructType\GuestCountsType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \room\StructType\GuestCountsType $guestCounts
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setGuestCounts(\room\StructType\GuestCountsType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return \room\StructType\StayDateRangeType|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \room\StructType\StayDateRangeType $stayDateRange
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setStayDateRange(\room\StructType\StayDateRangeType $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get RatePlanCodes value
     * @return \room\StructType\RatePlanCodesType|null
     */
    public function getRatePlanCodes()
    {
        return $this->RatePlanCodes;
    }
    /**
     * Set RatePlanCodes value
     * @param \room\StructType\RatePlanCodesType $ratePlanCodes
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setRatePlanCodes(\room\StructType\RatePlanCodesType $ratePlanCodes = null)
    {
        $this->RatePlanCodes = $ratePlanCodes;
        return $this;
    }
    /**
     * Get PromotionalCode value
     * @return \room\StructType\PromotionalCode|null
     */
    public function getPromotionalCode()
    {
        return $this->PromotionalCode;
    }
    /**
     * Set PromotionalCode value
     * @param \room\StructType\PromotionalCode $promotionalCode
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setPromotionalCode(\room\StructType\PromotionalCode $promotionalCode = null)
    {
        $this->PromotionalCode = $promotionalCode;
        return $this;
    }
    /**
     * Get RateCategory value
     * @return string|null
     */
    public function getRateCategory()
    {
        return $this->RateCategory;
    }
    /**
     * Set RateCategory value
     * @param string $rateCategory
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setRateCategory($rateCategory = null)
    {
        // validation for constraint: string
        if (!is_null($rateCategory) && !is_string($rateCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateCategory, true), gettype($rateCategory)), __LINE__);
        }
        $this->RateCategory = $rateCategory;
        return $this;
    }
    /**
     * Get RoomCodes value
     * @return \room\StructType\RoomCodesType|null
     */
    public function getRoomCodes()
    {
        return $this->RoomCodes;
    }
    /**
     * Set RoomCodes value
     * @param \room\StructType\RoomCodesType $roomCodes
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setRoomCodes(\room\StructType\RoomCodesType $roomCodes = null)
    {
        $this->RoomCodes = $roomCodes;
        return $this;
    }
    /**
     * Get RoomBlockCode value
     * @return string|null
     */
    public function getRoomBlockCode()
    {
        return $this->RoomBlockCode;
    }
    /**
     * Set RoomBlockCode value
     * @param string $roomBlockCode
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setRoomBlockCode($roomBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomBlockCode) && !is_string($roomBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomBlockCode, true), gettype($roomBlockCode)), __LINE__);
        }
        $this->RoomBlockCode = $roomBlockCode;
        return $this;
    }
    /**
     * Get CompanyRef value
     * @return \room\StructType\CompanyRefType|null
     */
    public function getCompanyRef()
    {
        return $this->CompanyRef;
    }
    /**
     * Set CompanyRef value
     * @param \room\StructType\CompanyRefType $companyRef
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setCompanyRef(\room\StructType\CompanyRefType $companyRef = null)
    {
        $this->CompanyRef = $companyRef;
        return $this;
    }
    /**
     * Get Mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->Mode;
    }
    /**
     * Set Mode value
     * @param string $mode
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setMode($mode = null)
    {
        // validation for constraint: string
        if (!is_null($mode) && !is_string($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mode, true), gettype($mode)), __LINE__);
        }
        $this->Mode = $mode;
        return $this;
    }
    /**
     * Get AddRoomRateInfo value
     * @return bool|null
     */
    public function getAddRoomRateInfo()
    {
        return $this->AddRoomRateInfo;
    }
    /**
     * Set AddRoomRateInfo value
     * @param bool $addRoomRateInfo
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setAddRoomRateInfo($addRoomRateInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($addRoomRateInfo) && !is_bool($addRoomRateInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addRoomRateInfo, true), gettype($addRoomRateInfo)), __LINE__);
        }
        $this->AddRoomRateInfo = $addRoomRateInfo;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->Lang;
    }
    /**
     * Set Lang value
     * @param string $lang
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->Lang = $lang;
        return $this;
    }
    /**
     * Get Debug value
     * @return bool|null
     */
    public function getDebug()
    {
        return $this->Debug;
    }
    /**
     * Set Debug value
     * @param bool $debug
     * @return \room\StructType\GetAvailabilityRQ
     */
    public function setDebug($debug = null)
    {
        // validation for constraint: boolean
        if (!is_null($debug) && !is_bool($debug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($debug, true), gettype($debug)), __LINE__);
        }
        $this->Debug = $debug;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\GetAvailabilityRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
