<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreeNightsLosRuleType StructType
 * @subpackage Structs
 */
class FreeNightsLosRuleType extends AbstractStructBase
{
    /**
     * The FreeNightType
     * @var string
     */
    public $FreeNightType;
    /**
     * The RepeatPattern
     * @var bool
     */
    public $RepeatPattern;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for FreeNightsLosRuleType
     * @uses FreeNightsLosRuleType::setFreeNightType()
     * @uses FreeNightsLosRuleType::setRepeatPattern()
     * @uses FreeNightsLosRuleType::setRatePlanCode()
     * @param string $freeNightType
     * @param bool $repeatPattern
     * @param string $ratePlanCode
     */
    public function __construct($freeNightType = null, $repeatPattern = null, $ratePlanCode = null)
    {
        $this
            ->setFreeNightType($freeNightType)
            ->setRepeatPattern($repeatPattern)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get FreeNightType value
     * @return string|null
     */
    public function getFreeNightType()
    {
        return $this->FreeNightType;
    }
    /**
     * Set FreeNightType value
     * @param string $freeNightType
     * @return \room\StructType\FreeNightsLosRuleType
     */
    public function setFreeNightType($freeNightType = null)
    {
        // validation for constraint: string
        if (!is_null($freeNightType) && !is_string($freeNightType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freeNightType, true), gettype($freeNightType)), __LINE__);
        }
        $this->FreeNightType = $freeNightType;
        return $this;
    }
    /**
     * Get RepeatPattern value
     * @return bool|null
     */
    public function getRepeatPattern()
    {
        return $this->RepeatPattern;
    }
    /**
     * Set RepeatPattern value
     * @param bool $repeatPattern
     * @return \room\StructType\FreeNightsLosRuleType
     */
    public function setRepeatPattern($repeatPattern = null)
    {
        // validation for constraint: boolean
        if (!is_null($repeatPattern) && !is_bool($repeatPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($repeatPattern, true), gettype($repeatPattern)), __LINE__);
        }
        $this->RepeatPattern = $repeatPattern;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \room\StructType\FreeNightsLosRuleType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\FreeNightsLosRuleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
