<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountriesType StructType
 * @subpackage Structs
 */
class CountriesType extends AbstractStructBase
{
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \room\StructType\CountryType[]
     */
    public $Country;
    /**
     * Constructor method for CountriesType
     * @uses CountriesType::setCountry()
     * @param \room\StructType\CountryType[] $country
     */
    public function __construct(array $country = array())
    {
        $this
            ->setCountry($country);
    }
    /**
     * Get Country value
     * @return \room\StructType\CountryType[]|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * This method is responsible for validating the values passed to the setCountry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountryForArrayConstraintsFromSetCountry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $countriesTypeCountryItem) {
            // validation for constraint: itemType
            if (!$countriesTypeCountryItem instanceof \room\StructType\CountryType) {
                $invalidValues[] = is_object($countriesTypeCountryItem) ? get_class($countriesTypeCountryItem) : sprintf('%s(%s)', gettype($countriesTypeCountryItem), var_export($countriesTypeCountryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Country property can only contain items of type \room\StructType\CountryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Country value
     * @throws \InvalidArgumentException
     * @param \room\StructType\CountryType[] $country
     * @return \room\StructType\CountriesType
     */
    public function setCountry(array $country = array())
    {
        // validation for constraint: array
        if ('' !== ($countryArrayErrorMessage = self::validateCountryForArrayConstraintsFromSetCountry($country))) {
            throw new \InvalidArgumentException($countryArrayErrorMessage, __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Add item to Country value
     * @throws \InvalidArgumentException
     * @param \room\StructType\CountryType $item
     * @return \room\StructType\CountriesType
     */
    public function addToCountry(\room\StructType\CountryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\CountryType) {
            throw new \InvalidArgumentException(sprintf('The Country property can only contain items of type \room\StructType\CountryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Country[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\CountriesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
