<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountiesType StructType
 * @subpackage Structs
 */
class CountiesType extends AbstractStructBase
{
    /**
     * The County
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $County;
    /**
     * Constructor method for CountiesType
     * @uses CountiesType::setCounty()
     * @param string[] $county
     */
    public function __construct(array $county = array())
    {
        $this
            ->setCounty($county);
    }
    /**
     * Get County value
     * @return string[]|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * This method is responsible for validating the values passed to the setCounty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCounty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountyForArrayConstraintsFromSetCounty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $countiesTypeCountyItem) {
            // validation for constraint: itemType
            if (!is_string($countiesTypeCountyItem)) {
                $invalidValues[] = is_object($countiesTypeCountyItem) ? get_class($countiesTypeCountyItem) : sprintf('%s(%s)', gettype($countiesTypeCountyItem), var_export($countiesTypeCountyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The County property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set County value
     * @throws \InvalidArgumentException
     * @param string[] $county
     * @return \room\StructType\CountiesType
     */
    public function setCounty(array $county = array())
    {
        // validation for constraint: array
        if ('' !== ($countyArrayErrorMessage = self::validateCountyForArrayConstraintsFromSetCounty($county))) {
            throw new \InvalidArgumentException($countyArrayErrorMessage, __LINE__);
        }
        $this->County = $county;
        return $this;
    }
    /**
     * Add item to County value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \room\StructType\CountiesType
     */
    public function addToCounty($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The County property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->County[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\CountiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
