<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestPriceAvailabilityType StructType
 * @subpackage Structs
 */
class BestPriceAvailabilityType extends AbstractStructBase
{
    /**
     * The PricesFrom
     * @var float
     */
    public $PricesFrom;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Count
     * @var int
     */
    public $Count;
    /**
     * The BoardBasis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DescriptionType
     */
    public $BoardBasis;
    /**
     * Constructor method for BestPriceAvailabilityType
     * @uses BestPriceAvailabilityType::setPricesFrom()
     * @uses BestPriceAvailabilityType::setCurrencyCode()
     * @uses BestPriceAvailabilityType::setCount()
     * @uses BestPriceAvailabilityType::setBoardBasis()
     * @param float $pricesFrom
     * @param string $currencyCode
     * @param int $count
     * @param \room\StructType\DescriptionType $boardBasis
     */
    public function __construct($pricesFrom = null, $currencyCode = null, $count = null, \room\StructType\DescriptionType $boardBasis = null)
    {
        $this
            ->setPricesFrom($pricesFrom)
            ->setCurrencyCode($currencyCode)
            ->setCount($count)
            ->setBoardBasis($boardBasis);
    }
    /**
     * Get PricesFrom value
     * @return float|null
     */
    public function getPricesFrom()
    {
        return $this->PricesFrom;
    }
    /**
     * Set PricesFrom value
     * @param float $pricesFrom
     * @return \room\StructType\BestPriceAvailabilityType
     */
    public function setPricesFrom($pricesFrom = null)
    {
        // validation for constraint: float
        if (!is_null($pricesFrom) && !(is_float($pricesFrom) || is_numeric($pricesFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricesFrom, true), gettype($pricesFrom)), __LINE__);
        }
        $this->PricesFrom = $pricesFrom;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \room\StructType\BestPriceAvailabilityType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \room\StructType\BestPriceAvailabilityType
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get BoardBasis value
     * @return \room\StructType\DescriptionType|null
     */
    public function getBoardBasis()
    {
        return $this->BoardBasis;
    }
    /**
     * Set BoardBasis value
     * @param \room\StructType\DescriptionType $boardBasis
     * @return \room\StructType\BestPriceAvailabilityType
     */
    public function setBoardBasis(\room\StructType\DescriptionType $boardBasis = null)
    {
        $this->BoardBasis = $boardBasis;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\BestPriceAvailabilityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
