<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseType StructType
 * @subpackage Structs
 */
class BaseType extends AbstractStructBase
{
    /**
     * The AmountAfterTax
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $AmountAfterTax;
    /**
     * The AmountAfterTaxWithoutLosRule
     * @var float
     */
    public $AmountAfterTaxWithoutLosRule;
    /**
     * The AmountBeforeTax
     * @var float
     */
    public $AmountBeforeTax;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for BaseType
     * @uses BaseType::setAmountAfterTax()
     * @uses BaseType::setAmountAfterTaxWithoutLosRule()
     * @uses BaseType::setAmountBeforeTax()
     * @uses BaseType::setCurrencyCode()
     * @param float $amountAfterTax
     * @param float $amountAfterTaxWithoutLosRule
     * @param float $amountBeforeTax
     * @param string $currencyCode
     */
    public function __construct($amountAfterTax = null, $amountAfterTaxWithoutLosRule = null, $amountBeforeTax = null, $currencyCode = null)
    {
        $this
            ->setAmountAfterTax($amountAfterTax)
            ->setAmountAfterTaxWithoutLosRule($amountAfterTaxWithoutLosRule)
            ->setAmountBeforeTax($amountBeforeTax)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get AmountAfterTax value
     * @return float
     */
    public function getAmountAfterTax()
    {
        return $this->AmountAfterTax;
    }
    /**
     * Set AmountAfterTax value
     * @param float $amountAfterTax
     * @return \room\StructType\BaseType
     */
    public function setAmountAfterTax($amountAfterTax = null)
    {
        // validation for constraint: float
        if (!is_null($amountAfterTax) && !(is_float($amountAfterTax) || is_numeric($amountAfterTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountAfterTax, true), gettype($amountAfterTax)), __LINE__);
        }
        $this->AmountAfterTax = $amountAfterTax;
        return $this;
    }
    /**
     * Get AmountAfterTaxWithoutLosRule value
     * @return float|null
     */
    public function getAmountAfterTaxWithoutLosRule()
    {
        return $this->AmountAfterTaxWithoutLosRule;
    }
    /**
     * Set AmountAfterTaxWithoutLosRule value
     * @param float $amountAfterTaxWithoutLosRule
     * @return \room\StructType\BaseType
     */
    public function setAmountAfterTaxWithoutLosRule($amountAfterTaxWithoutLosRule = null)
    {
        // validation for constraint: float
        if (!is_null($amountAfterTaxWithoutLosRule) && !(is_float($amountAfterTaxWithoutLosRule) || is_numeric($amountAfterTaxWithoutLosRule))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountAfterTaxWithoutLosRule, true), gettype($amountAfterTaxWithoutLosRule)), __LINE__);
        }
        $this->AmountAfterTaxWithoutLosRule = $amountAfterTaxWithoutLosRule;
        return $this;
    }
    /**
     * Get AmountBeforeTax value
     * @return float|null
     */
    public function getAmountBeforeTax()
    {
        return $this->AmountBeforeTax;
    }
    /**
     * Set AmountBeforeTax value
     * @param float $amountBeforeTax
     * @return \room\StructType\BaseType
     */
    public function setAmountBeforeTax($amountBeforeTax = null)
    {
        // validation for constraint: float
        if (!is_null($amountBeforeTax) && !(is_float($amountBeforeTax) || is_numeric($amountBeforeTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountBeforeTax, true), gettype($amountBeforeTax)), __LINE__);
        }
        $this->AmountBeforeTax = $amountBeforeTax;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \room\StructType\BaseType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\BaseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
