<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailableRoomRateType StructType
 * @subpackage Structs
 */
class AvailableRoomRateType extends AbstractStructBase
{
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RoomCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $RoomCode;
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RatesType
     */
    public $Rates;
    /**
     * The DailyAvailabilities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DailyAvailabilitiesType
     */
    public $DailyAvailabilities;
    /**
     * The RoomBlockCode
     * @var string
     */
    public $RoomBlockCode;
    /**
     * The Availability
     * @var int
     */
    public $Availability;
    /**
     * The BoardBasis
     * @var string
     */
    public $BoardBasis;
    /**
     * The BoardBasisDescription
     * @var string
     */
    public $BoardBasisDescription;
    /**
     * The StandardPrice
     * @var float
     */
    public $StandardPrice;
    /**
     * Constructor method for AvailableRoomRateType
     * @uses AvailableRoomRateType::setRatePlanCode()
     * @uses AvailableRoomRateType::setRoomCode()
     * @uses AvailableRoomRateType::setRates()
     * @uses AvailableRoomRateType::setDailyAvailabilities()
     * @uses AvailableRoomRateType::setRoomBlockCode()
     * @uses AvailableRoomRateType::setAvailability()
     * @uses AvailableRoomRateType::setBoardBasis()
     * @uses AvailableRoomRateType::setBoardBasisDescription()
     * @uses AvailableRoomRateType::setStandardPrice()
     * @param string $ratePlanCode
     * @param string $roomCode
     * @param \room\StructType\RatesType $rates
     * @param \room\StructType\DailyAvailabilitiesType $dailyAvailabilities
     * @param string $roomBlockCode
     * @param int $availability
     * @param string $boardBasis
     * @param string $boardBasisDescription
     * @param float $standardPrice
     */
    public function __construct($ratePlanCode = null, $roomCode = null, \room\StructType\RatesType $rates = null, \room\StructType\DailyAvailabilitiesType $dailyAvailabilities = null, $roomBlockCode = null, $availability = null, $boardBasis = null, $boardBasisDescription = null, $standardPrice = null)
    {
        $this
            ->setRatePlanCode($ratePlanCode)
            ->setRoomCode($roomCode)
            ->setRates($rates)
            ->setDailyAvailabilities($dailyAvailabilities)
            ->setRoomBlockCode($roomBlockCode)
            ->setAvailability($availability)
            ->setBoardBasis($boardBasis)
            ->setBoardBasisDescription($boardBasisDescription)
            ->setStandardPrice($standardPrice);
    }
    /**
     * Get RatePlanCode value
     * @return string
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \room\StructType\AvailableRoomRateType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RoomCode value
     * @return string
     */
    public function getRoomCode()
    {
        return $this->RoomCode;
    }
    /**
     * Set RoomCode value
     * @param string $roomCode
     * @return \room\StructType\AvailableRoomRateType
     */
    public function setRoomCode($roomCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomCode) && !is_string($roomCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomCode, true), gettype($roomCode)), __LINE__);
        }
        $this->RoomCode = $roomCode;
        return $this;
    }
    /**
     * Get Rates value
     * @return \room\StructType\RatesType|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \room\StructType\RatesType $rates
     * @return \room\StructType\AvailableRoomRateType
     */
    public function setRates(\room\StructType\RatesType $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get DailyAvailabilities value
     * @return \room\StructType\DailyAvailabilitiesType|null
     */
    public function getDailyAvailabilities()
    {
        return $this->DailyAvailabilities;
    }
    /**
     * Set DailyAvailabilities value
     * @param \room\StructType\DailyAvailabilitiesType $dailyAvailabilities
     * @return \room\StructType\AvailableRoomRateType
     */
    public function setDailyAvailabilities(\room\StructType\DailyAvailabilitiesType $dailyAvailabilities = null)
    {
        $this->DailyAvailabilities = $dailyAvailabilities;
        return $this;
    }
    /**
     * Get RoomBlockCode value
     * @return string|null
     */
    public function getRoomBlockCode()
    {
        return $this->RoomBlockCode;
    }
    /**
     * Set RoomBlockCode value
     * @param string $roomBlockCode
     * @return \room\StructType\AvailableRoomRateType
     */
    public function setRoomBlockCode($roomBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomBlockCode) && !is_string($roomBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomBlockCode, true), gettype($roomBlockCode)), __LINE__);
        }
        $this->RoomBlockCode = $roomBlockCode;
        return $this;
    }
    /**
     * Get Availability value
     * @return int|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param int $availability
     * @return \room\StructType\AvailableRoomRateType
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: int
        if (!is_null($availability) && !(is_int($availability) || ctype_digit($availability))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availability, true), gettype($availability)), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get BoardBasis value
     * @return string|null
     */
    public function getBoardBasis()
    {
        return $this->BoardBasis;
    }
    /**
     * Set BoardBasis value
     * @param string $boardBasis
     * @return \room\StructType\AvailableRoomRateType
     */
    public function setBoardBasis($boardBasis = null)
    {
        // validation for constraint: string
        if (!is_null($boardBasis) && !is_string($boardBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boardBasis, true), gettype($boardBasis)), __LINE__);
        }
        $this->BoardBasis = $boardBasis;
        return $this;
    }
    /**
     * Get BoardBasisDescription value
     * @return string|null
     */
    public function getBoardBasisDescription()
    {
        return $this->BoardBasisDescription;
    }
    /**
     * Set BoardBasisDescription value
     * @param string $boardBasisDescription
     * @return \room\StructType\AvailableRoomRateType
     */
    public function setBoardBasisDescription($boardBasisDescription = null)
    {
        // validation for constraint: string
        if (!is_null($boardBasisDescription) && !is_string($boardBasisDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boardBasisDescription, true), gettype($boardBasisDescription)), __LINE__);
        }
        $this->BoardBasisDescription = $boardBasisDescription;
        return $this;
    }
    /**
     * Get StandardPrice value
     * @return float|null
     */
    public function getStandardPrice()
    {
        return $this->StandardPrice;
    }
    /**
     * Set StandardPrice value
     * @param float $standardPrice
     * @return \room\StructType\AvailableRoomRateType
     */
    public function setStandardPrice($standardPrice = null)
    {
        // validation for constraint: float
        if (!is_null($standardPrice) && !(is_float($standardPrice) || is_numeric($standardPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($standardPrice, true), gettype($standardPrice)), __LINE__);
        }
        $this->StandardPrice = $standardPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\AvailableRoomRateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
