<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorisationProviderType StructType
 * @subpackage Structs
 */
class AuthorisationProviderType extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Name;
    /**
     * The Attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \room\StructType\AttributeType[]
     */
    public $Attribute;
    /**
     * Constructor method for AuthorisationProviderType
     * @uses AuthorisationProviderType::setName()
     * @uses AuthorisationProviderType::setAttribute()
     * @param string $name
     * @param \room\StructType\AttributeType[] $attribute
     */
    public function __construct($name = null, array $attribute = array())
    {
        $this
            ->setName($name)
            ->setAttribute($attribute);
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \room\StructType\AuthorisationProviderType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Attribute value
     * @return \room\StructType\AttributeType[]|null
     */
    public function getAttribute()
    {
        return $this->Attribute;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $authorisationProviderTypeAttributeItem) {
            // validation for constraint: itemType
            if (!$authorisationProviderTypeAttributeItem instanceof \room\StructType\AttributeType) {
                $invalidValues[] = is_object($authorisationProviderTypeAttributeItem) ? get_class($authorisationProviderTypeAttributeItem) : sprintf('%s(%s)', gettype($authorisationProviderTypeAttributeItem), var_export($authorisationProviderTypeAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attribute property can only contain items of type \room\StructType\AttributeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attribute value
     * @throws \InvalidArgumentException
     * @param \room\StructType\AttributeType[] $attribute
     * @return \room\StructType\AuthorisationProviderType
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        $this->Attribute = $attribute;
        return $this;
    }
    /**
     * Add item to Attribute value
     * @throws \InvalidArgumentException
     * @param \room\StructType\AttributeType $item
     * @return \room\StructType\AuthorisationProviderType
     */
    public function addToAttribute(\room\StructType\AttributeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\AttributeType) {
            throw new \InvalidArgumentException(sprintf('The Attribute property can only contain items of type \room\StructType\AttributeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attribute[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\AuthorisationProviderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
