<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessCodeItem StructType
 * @subpackage Structs
 */
class AccessCodeItem extends AbstractStructBase
{
    /**
     * The AccessCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccessCode;
    /**
     * The AccessCodeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccessCodeDescription;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for AccessCodeItem
     * @uses AccessCodeItem::setAccessCode()
     * @uses AccessCodeItem::setAccessCodeDescription()
     * @uses AccessCodeItem::setDescription()
     * @param string $accessCode
     * @param string $accessCodeDescription
     * @param string $description
     */
    public function __construct($accessCode = null, $accessCodeDescription = null, $description = null)
    {
        $this
            ->setAccessCode($accessCode)
            ->setAccessCodeDescription($accessCodeDescription)
            ->setDescription($description);
    }
    /**
     * Get AccessCode value
     * @return string|null
     */
    public function getAccessCode()
    {
        return $this->AccessCode;
    }
    /**
     * Set AccessCode value
     * @param string $accessCode
     * @return \room\StructType\AccessCodeItem
     */
    public function setAccessCode($accessCode = null)
    {
        // validation for constraint: string
        if (!is_null($accessCode) && !is_string($accessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCode, true), gettype($accessCode)), __LINE__);
        }
        $this->AccessCode = $accessCode;
        return $this;
    }
    /**
     * Get AccessCodeDescription value
     * @return string|null
     */
    public function getAccessCodeDescription()
    {
        return $this->AccessCodeDescription;
    }
    /**
     * Set AccessCodeDescription value
     * @param string $accessCodeDescription
     * @return \room\StructType\AccessCodeItem
     */
    public function setAccessCodeDescription($accessCodeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($accessCodeDescription) && !is_string($accessCodeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCodeDescription, true), gettype($accessCodeDescription)), __LINE__);
        }
        $this->AccessCodeDescription = $accessCodeDescription;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \room\StructType\AccessCodeItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\AccessCodeItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
