<?php

namespace room\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Make ServiceType
 * @subpackage Services
 */
class Make extends AbstractSoapClientBase
{
    /**
     * Sets the Auth SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \room\StructType\Auth $auth
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuth(\room\StructType\Auth $auth, $nameSpace = 'http://guestline.com/RoomLynxAPI', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Auth', $auth, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named MakeProfile
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\MakeProfileRQ $makeProfileRequestMessagePart
     * @return \room\StructType\MakeProfileRS|bool
     */
    public function MakeProfile(\room\StructType\MakeProfileRQ $makeProfileRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->MakeProfile($makeProfileRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MakeReservation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\MakeReservationRQ $makeReservationRequestMessagePart
     * @return \room\StructType\MakeReservationRS|bool
     */
    public function MakeReservation(\room\StructType\MakeReservationRQ $makeReservationRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->MakeReservation($makeReservationRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \room\StructType\MakeProfileRS|\room\StructType\MakeReservationRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
