<?php

namespace room\EnumType;

/**
 * This class stands for ResultCodeType EnumType
 * @subpackage Enumerations
 */
class ResultCodeType
{
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'SuccessWithWarnings'
     * @return string 'SuccessWithWarnings'
     */
    const VALUE_SUCCESS_WITH_WARNINGS = 'SuccessWithWarnings';
    /**
     * Constant for value 'Failure'
     * @return string 'Failure'
     */
    const VALUE_FAILURE = 'Failure';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_SUCCESS_WITH_WARNINGS
     * @uses self::VALUE_FAILURE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCESS,
            self::VALUE_SUCCESS_WITH_WARNINGS,
            self::VALUE_FAILURE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
