<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelephoneNumbersType StructType
 * @subpackage Structs
 */
class TelephoneNumbersType extends AbstractStructBase
{
    /**
     * The TelephoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $TelephoneNumber;
    /**
     * Constructor method for TelephoneNumbersType
     * @uses TelephoneNumbersType::setTelephoneNumber()
     * @param string[] $telephoneNumber
     */
    public function __construct(array $telephoneNumber = array())
    {
        $this
            ->setTelephoneNumber($telephoneNumber);
    }
    /**
     * Get TelephoneNumber value
     * @return string[]|null
     */
    public function getTelephoneNumber()
    {
        return $this->TelephoneNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephoneNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephoneNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneNumberForArrayConstraintsFromSetTelephoneNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $telephoneNumbersTypeTelephoneNumberItem) {
            // validation for constraint: itemType
            if (!is_string($telephoneNumbersTypeTelephoneNumberItem)) {
                $invalidValues[] = is_object($telephoneNumbersTypeTelephoneNumberItem) ? get_class($telephoneNumbersTypeTelephoneNumberItem) : sprintf('%s(%s)', gettype($telephoneNumbersTypeTelephoneNumberItem), var_export($telephoneNumbersTypeTelephoneNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TelephoneNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TelephoneNumber value
     * @throws \InvalidArgumentException
     * @param string[] $telephoneNumber
     * @return \room\StructType\TelephoneNumbersType
     */
    public function setTelephoneNumber(array $telephoneNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneNumberArrayErrorMessage = self::validateTelephoneNumberForArrayConstraintsFromSetTelephoneNumber($telephoneNumber))) {
            throw new \InvalidArgumentException($telephoneNumberArrayErrorMessage, __LINE__);
        }
        $this->TelephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Add item to TelephoneNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \room\StructType\TelephoneNumbersType
     */
    public function addToTelephoneNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TelephoneNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TelephoneNumber[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\TelephoneNumbersType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
