<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomsType StructType
 * @subpackage Structs
 */
class RoomsType extends AbstractStructBase
{
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \room\StructType\RoomType[]
     */
    public $Room;
    /**
     * Constructor method for RoomsType
     * @uses RoomsType::setRoom()
     * @param \room\StructType\RoomType[] $room
     */
    public function __construct(array $room = array())
    {
        $this
            ->setRoom($room);
    }
    /**
     * Get Room value
     * @return \room\StructType\RoomType[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * This method is responsible for validating the values passed to the setRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomForArrayConstraintsFromSetRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomsTypeRoomItem) {
            // validation for constraint: itemType
            if (!$roomsTypeRoomItem instanceof \room\StructType\RoomType) {
                $invalidValues[] = is_object($roomsTypeRoomItem) ? get_class($roomsTypeRoomItem) : sprintf('%s(%s)', gettype($roomsTypeRoomItem), var_export($roomsTypeRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Room property can only contain items of type \room\StructType\RoomType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Room value
     * @throws \InvalidArgumentException
     * @param \room\StructType\RoomType[] $room
     * @return \room\StructType\RoomsType
     */
    public function setRoom(array $room = array())
    {
        // validation for constraint: array
        if ('' !== ($roomArrayErrorMessage = self::validateRoomForArrayConstraintsFromSetRoom($room))) {
            throw new \InvalidArgumentException($roomArrayErrorMessage, __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \room\StructType\RoomType $item
     * @return \room\StructType\RoomsType
     */
    public function addToRoom(\room\StructType\RoomType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\RoomType) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of type \room\StructType\RoomType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RoomsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
