<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRatesType StructType
 * @subpackage Structs
 */
class RoomRatesType extends AbstractStructBase
{
    /**
     * The RoomRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \room\StructType\RoomRateType[]
     */
    public $RoomRate;
    /**
     * Constructor method for RoomRatesType
     * @uses RoomRatesType::setRoomRate()
     * @param \room\StructType\RoomRateType[] $roomRate
     */
    public function __construct(array $roomRate = array())
    {
        $this
            ->setRoomRate($roomRate);
    }
    /**
     * Get RoomRate value
     * @return \room\StructType\RoomRateType[]|null
     */
    public function getRoomRate()
    {
        return $this->RoomRate;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomRateForArrayConstraintsFromSetRoomRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRatesTypeRoomRateItem) {
            // validation for constraint: itemType
            if (!$roomRatesTypeRoomRateItem instanceof \room\StructType\RoomRateType) {
                $invalidValues[] = is_object($roomRatesTypeRoomRateItem) ? get_class($roomRatesTypeRoomRateItem) : sprintf('%s(%s)', gettype($roomRatesTypeRoomRateItem), var_export($roomRatesTypeRoomRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomRate property can only contain items of type \room\StructType\RoomRateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomRate value
     * @throws \InvalidArgumentException
     * @param \room\StructType\RoomRateType[] $roomRate
     * @return \room\StructType\RoomRatesType
     */
    public function setRoomRate(array $roomRate = array())
    {
        // validation for constraint: array
        if ('' !== ($roomRateArrayErrorMessage = self::validateRoomRateForArrayConstraintsFromSetRoomRate($roomRate))) {
            throw new \InvalidArgumentException($roomRateArrayErrorMessage, __LINE__);
        }
        $this->RoomRate = $roomRate;
        return $this;
    }
    /**
     * Add item to RoomRate value
     * @throws \InvalidArgumentException
     * @param \room\StructType\RoomRateType $item
     * @return \room\StructType\RoomRatesType
     */
    public function addToRoomRate(\room\StructType\RoomRateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\RoomRateType) {
            throw new \InvalidArgumentException(sprintf('The RoomRate property can only contain items of type \room\StructType\RoomRateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomRate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RoomRatesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
