<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomImagesType StructType
 * @subpackage Structs
 */
class RoomImagesType extends AbstractStructBase
{
    /**
     * The RoomImage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \room\StructType\RoomImageType[]
     */
    public $RoomImage;
    /**
     * Constructor method for RoomImagesType
     * @uses RoomImagesType::setRoomImage()
     * @param \room\StructType\RoomImageType[] $roomImage
     */
    public function __construct(array $roomImage = array())
    {
        $this
            ->setRoomImage($roomImage);
    }
    /**
     * Get RoomImage value
     * @return \room\StructType\RoomImageType[]|null
     */
    public function getRoomImage()
    {
        return $this->RoomImage;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomImage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomImage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomImageForArrayConstraintsFromSetRoomImage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomImagesTypeRoomImageItem) {
            // validation for constraint: itemType
            if (!$roomImagesTypeRoomImageItem instanceof \room\StructType\RoomImageType) {
                $invalidValues[] = is_object($roomImagesTypeRoomImageItem) ? get_class($roomImagesTypeRoomImageItem) : sprintf('%s(%s)', gettype($roomImagesTypeRoomImageItem), var_export($roomImagesTypeRoomImageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomImage property can only contain items of type \room\StructType\RoomImageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomImage value
     * @throws \InvalidArgumentException
     * @param \room\StructType\RoomImageType[] $roomImage
     * @return \room\StructType\RoomImagesType
     */
    public function setRoomImage(array $roomImage = array())
    {
        // validation for constraint: array
        if ('' !== ($roomImageArrayErrorMessage = self::validateRoomImageForArrayConstraintsFromSetRoomImage($roomImage))) {
            throw new \InvalidArgumentException($roomImageArrayErrorMessage, __LINE__);
        }
        $this->RoomImage = $roomImage;
        return $this;
    }
    /**
     * Add item to RoomImage value
     * @throws \InvalidArgumentException
     * @param \room\StructType\RoomImageType $item
     * @return \room\StructType\RoomImagesType
     */
    public function addToRoomImage(\room\StructType\RoomImageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\RoomImageType) {
            throw new \InvalidArgumentException(sprintf('The RoomImage property can only contain items of type \room\StructType\RoomImageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomImage[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RoomImagesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
