<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictionsType StructType
 * @subpackage Structs
 */
class RestrictionsType extends AbstractStructBase
{
    /**
     * The Restriction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \room\StructType\RestrictionType[]
     */
    public $Restriction;
    /**
     * Constructor method for RestrictionsType
     * @uses RestrictionsType::setRestriction()
     * @param \room\StructType\RestrictionType[] $restriction
     */
    public function __construct(array $restriction = array())
    {
        $this
            ->setRestriction($restriction);
    }
    /**
     * Get Restriction value
     * @return \room\StructType\RestrictionType[]|null
     */
    public function getRestriction()
    {
        return $this->Restriction;
    }
    /**
     * This method is responsible for validating the values passed to the setRestriction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestriction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrictionForArrayConstraintsFromSetRestriction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $restrictionsTypeRestrictionItem) {
            // validation for constraint: itemType
            if (!$restrictionsTypeRestrictionItem instanceof \room\StructType\RestrictionType) {
                $invalidValues[] = is_object($restrictionsTypeRestrictionItem) ? get_class($restrictionsTypeRestrictionItem) : sprintf('%s(%s)', gettype($restrictionsTypeRestrictionItem), var_export($restrictionsTypeRestrictionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restriction property can only contain items of type \room\StructType\RestrictionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restriction value
     * @throws \InvalidArgumentException
     * @param \room\StructType\RestrictionType[] $restriction
     * @return \room\StructType\RestrictionsType
     */
    public function setRestriction(array $restriction = array())
    {
        // validation for constraint: array
        if ('' !== ($restrictionArrayErrorMessage = self::validateRestrictionForArrayConstraintsFromSetRestriction($restriction))) {
            throw new \InvalidArgumentException($restrictionArrayErrorMessage, __LINE__);
        }
        $this->Restriction = $restriction;
        return $this;
    }
    /**
     * Add item to Restriction value
     * @throws \InvalidArgumentException
     * @param \room\StructType\RestrictionType $item
     * @return \room\StructType\RestrictionsType
     */
    public function addToRestriction(\room\StructType\RestrictionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\RestrictionType) {
            throw new \InvalidArgumentException(sprintf('The Restriction property can only contain items of type \room\StructType\RestrictionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restriction[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RestrictionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
