<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateType StructType
 * @subpackage Structs
 */
class RateType extends AbstractStructBase
{
    /**
     * The From
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $From;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $To;
    /**
     * The Base
     * @var \room\StructType\BaseType
     */
    public $Base;
    /**
     * The NumberOfNights
     * @var int
     */
    public $NumberOfNights;
    /**
     * Constructor method for RateType
     * @uses RateType::setFrom()
     * @uses RateType::setTo()
     * @uses RateType::setBase()
     * @uses RateType::setNumberOfNights()
     * @param string $from
     * @param string $to
     * @param \room\StructType\BaseType $base
     * @param int $numberOfNights
     */
    public function __construct($from = null, $to = null, \room\StructType\BaseType $base = null, $numberOfNights = null)
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setBase($base)
            ->setNumberOfNights($numberOfNights);
    }
    /**
     * Get From value
     * @return string
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \room\StructType\RateType
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return string
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \room\StructType\RateType
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
    /**
     * Get Base value
     * @return \room\StructType\BaseType|null
     */
    public function getBase()
    {
        return $this->Base;
    }
    /**
     * Set Base value
     * @param \room\StructType\BaseType $base
     * @return \room\StructType\RateType
     */
    public function setBase(\room\StructType\BaseType $base = null)
    {
        $this->Base = $base;
        return $this;
    }
    /**
     * Get NumberOfNights value
     * @return int|null
     */
    public function getNumberOfNights()
    {
        return $this->NumberOfNights;
    }
    /**
     * Set NumberOfNights value
     * @param int $numberOfNights
     * @return \room\StructType\RateType
     */
    public function setNumberOfNights($numberOfNights = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfNights) && !(is_int($numberOfNights) || ctype_digit($numberOfNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfNights, true), gettype($numberOfNights)), __LINE__);
        }
        $this->NumberOfNights = $numberOfNights;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
