<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanCodesType StructType
 * @subpackage Structs
 */
class RatePlanCodesType extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $Code;
    /**
     * Constructor method for RatePlanCodesType
     * @uses RatePlanCodesType::setCode()
     * @param string[] $code
     */
    public function __construct(array $code = array())
    {
        $this
            ->setCode($code);
    }
    /**
     * Get Code value
     * @return string[]|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * This method is responsible for validating the values passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodeForArrayConstraintsFromSetCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanCodesTypeCodeItem) {
            // validation for constraint: itemType
            if (!is_string($ratePlanCodesTypeCodeItem)) {
                $invalidValues[] = is_object($ratePlanCodesTypeCodeItem) ? get_class($ratePlanCodesTypeCodeItem) : sprintf('%s(%s)', gettype($ratePlanCodesTypeCodeItem), var_export($ratePlanCodesTypeCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Code property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Code value
     * @throws \InvalidArgumentException
     * @param string[] $code
     * @return \room\StructType\RatePlanCodesType
     */
    public function setCode(array $code = array())
    {
        // validation for constraint: array
        if ('' !== ($codeArrayErrorMessage = self::validateCodeForArrayConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeArrayErrorMessage, __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Add item to Code value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \room\StructType\RatePlanCodesType
     */
    public function addToCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Code property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Code[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RatePlanCodesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
