<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileType StructType
 * @subpackage Structs
 */
class ProfileType extends AbstractStructBase
{
    /**
     * The NamePrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NamePrefix;
    /**
     * The Firstname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Firstname;
    /**
     * The Lastname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Lastname;
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProfileType;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\AddressType
     */
    public $Address;
    /**
     * The ContactDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\ContactDetailsType
     */
    public $ContactDetails;
    /**
     * The MailListEnrolment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MailListEnrolment;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\CompanyType
     */
    public $Company;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\Attributes
     */
    public $Attributes;
    /**
     * The AgeGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AgeGroup;
    /**
     * The StudentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StudentID;
    /**
     * The VipLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VipLevel;
    /**
     * The PrfRef
     * @var string
     */
    public $PrfRef;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The ProfileRPH
     * @var int
     */
    public $ProfileRPH;
    /**
     * Constructor method for ProfileType
     * @uses ProfileType::setNamePrefix()
     * @uses ProfileType::setFirstname()
     * @uses ProfileType::setLastname()
     * @uses ProfileType::setProfileType()
     * @uses ProfileType::setAddress()
     * @uses ProfileType::setContactDetails()
     * @uses ProfileType::setMailListEnrolment()
     * @uses ProfileType::setCompany()
     * @uses ProfileType::setAttributes()
     * @uses ProfileType::setAgeGroup()
     * @uses ProfileType::setStudentID()
     * @uses ProfileType::setVipLevel()
     * @uses ProfileType::setPrfRef()
     * @uses ProfileType::setPassword()
     * @uses ProfileType::setProfileRPH()
     * @param string $namePrefix
     * @param string $firstname
     * @param string $lastname
     * @param string $profileType
     * @param \room\StructType\AddressType $address
     * @param \room\StructType\ContactDetailsType $contactDetails
     * @param bool $mailListEnrolment
     * @param \room\StructType\CompanyType $company
     * @param \room\StructType\Attributes $attributes
     * @param int $ageGroup
     * @param string $studentID
     * @param string $vipLevel
     * @param string $prfRef
     * @param string $password
     * @param int $profileRPH
     */
    public function __construct($namePrefix = null, $firstname = null, $lastname = null, $profileType = null, \room\StructType\AddressType $address = null, \room\StructType\ContactDetailsType $contactDetails = null, $mailListEnrolment = null, \room\StructType\CompanyType $company = null, \room\StructType\Attributes $attributes = null, $ageGroup = null, $studentID = null, $vipLevel = null, $prfRef = null, $password = null, $profileRPH = null)
    {
        $this
            ->setNamePrefix($namePrefix)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setProfileType($profileType)
            ->setAddress($address)
            ->setContactDetails($contactDetails)
            ->setMailListEnrolment($mailListEnrolment)
            ->setCompany($company)
            ->setAttributes($attributes)
            ->setAgeGroup($ageGroup)
            ->setStudentID($studentID)
            ->setVipLevel($vipLevel)
            ->setPrfRef($prfRef)
            ->setPassword($password)
            ->setProfileRPH($profileRPH);
    }
    /**
     * Get NamePrefix value
     * @return string|null
     */
    public function getNamePrefix()
    {
        return $this->NamePrefix;
    }
    /**
     * Set NamePrefix value
     * @param string $namePrefix
     * @return \room\StructType\ProfileType
     */
    public function setNamePrefix($namePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namePrefix) && !is_string($namePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namePrefix, true), gettype($namePrefix)), __LINE__);
        }
        $this->NamePrefix = $namePrefix;
        return $this;
    }
    /**
     * Get Firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->Firstname;
    }
    /**
     * Set Firstname value
     * @param string $firstname
     * @return \room\StructType\ProfileType
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->Firstname = $firstname;
        return $this;
    }
    /**
     * Get Lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->Lastname;
    }
    /**
     * Set Lastname value
     * @param string $lastname
     * @return \room\StructType\ProfileType
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastname, true), gettype($lastname)), __LINE__);
        }
        $this->Lastname = $lastname;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @param string $profileType
     * @return \room\StructType\ProfileType
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: string
        if (!is_null($profileType) && !is_string($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileType, true), gettype($profileType)), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get Address value
     * @return \room\StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \room\StructType\AddressType $address
     * @return \room\StructType\ProfileType
     */
    public function setAddress(\room\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactDetails value
     * @return \room\StructType\ContactDetailsType|null
     */
    public function getContactDetails()
    {
        return $this->ContactDetails;
    }
    /**
     * Set ContactDetails value
     * @param \room\StructType\ContactDetailsType $contactDetails
     * @return \room\StructType\ProfileType
     */
    public function setContactDetails(\room\StructType\ContactDetailsType $contactDetails = null)
    {
        $this->ContactDetails = $contactDetails;
        return $this;
    }
    /**
     * Get MailListEnrolment value
     * @return bool|null
     */
    public function getMailListEnrolment()
    {
        return $this->MailListEnrolment;
    }
    /**
     * Set MailListEnrolment value
     * @param bool $mailListEnrolment
     * @return \room\StructType\ProfileType
     */
    public function setMailListEnrolment($mailListEnrolment = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailListEnrolment) && !is_bool($mailListEnrolment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mailListEnrolment, true), gettype($mailListEnrolment)), __LINE__);
        }
        $this->MailListEnrolment = $mailListEnrolment;
        return $this;
    }
    /**
     * Get Company value
     * @return \room\StructType\CompanyType|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param \room\StructType\CompanyType $company
     * @return \room\StructType\ProfileType
     */
    public function setCompany(\room\StructType\CompanyType $company = null)
    {
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Attributes value
     * @return \room\StructType\Attributes|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @param \room\StructType\Attributes $attributes
     * @return \room\StructType\ProfileType
     */
    public function setAttributes(\room\StructType\Attributes $attributes = null)
    {
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Get AgeGroup value
     * @return int|null
     */
    public function getAgeGroup()
    {
        return $this->AgeGroup;
    }
    /**
     * Set AgeGroup value
     * @param int $ageGroup
     * @return \room\StructType\ProfileType
     */
    public function setAgeGroup($ageGroup = null)
    {
        // validation for constraint: int
        if (!is_null($ageGroup) && !(is_int($ageGroup) || ctype_digit($ageGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ageGroup, true), gettype($ageGroup)), __LINE__);
        }
        $this->AgeGroup = $ageGroup;
        return $this;
    }
    /**
     * Get StudentID value
     * @return string|null
     */
    public function getStudentID()
    {
        return $this->StudentID;
    }
    /**
     * Set StudentID value
     * @param string $studentID
     * @return \room\StructType\ProfileType
     */
    public function setStudentID($studentID = null)
    {
        // validation for constraint: string
        if (!is_null($studentID) && !is_string($studentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($studentID, true), gettype($studentID)), __LINE__);
        }
        $this->StudentID = $studentID;
        return $this;
    }
    /**
     * Get VipLevel value
     * @return string|null
     */
    public function getVipLevel()
    {
        return $this->VipLevel;
    }
    /**
     * Set VipLevel value
     * @param string $vipLevel
     * @return \room\StructType\ProfileType
     */
    public function setVipLevel($vipLevel = null)
    {
        // validation for constraint: string
        if (!is_null($vipLevel) && !is_string($vipLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vipLevel, true), gettype($vipLevel)), __LINE__);
        }
        $this->VipLevel = $vipLevel;
        return $this;
    }
    /**
     * Get PrfRef value
     * @return string|null
     */
    public function getPrfRef()
    {
        return $this->PrfRef;
    }
    /**
     * Set PrfRef value
     * @param string $prfRef
     * @return \room\StructType\ProfileType
     */
    public function setPrfRef($prfRef = null)
    {
        // validation for constraint: string
        if (!is_null($prfRef) && !is_string($prfRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prfRef, true), gettype($prfRef)), __LINE__);
        }
        $this->PrfRef = $prfRef;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \room\StructType\ProfileType
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get ProfileRPH value
     * @return int|null
     */
    public function getProfileRPH()
    {
        return $this->ProfileRPH;
    }
    /**
     * Set ProfileRPH value
     * @param int $profileRPH
     * @return \room\StructType\ProfileType
     */
    public function setProfileRPH($profileRPH = null)
    {
        // validation for constraint: int
        if (!is_null($profileRPH) && !(is_int($profileRPH) || ctype_digit($profileRPH))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileRPH, true), gettype($profileRPH)), __LINE__);
        }
        $this->ProfileRPH = $profileRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\ProfileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
