<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealsType StructType
 * @subpackage Structs
 */
class MealsType extends AbstractStructBase
{
    /**
     * The Meal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \room\StructType\Meal[]
     */
    public $Meal;
    /**
     * Constructor method for MealsType
     * @uses MealsType::setMeal()
     * @param \room\StructType\Meal[] $meal
     */
    public function __construct(array $meal = array())
    {
        $this
            ->setMeal($meal);
    }
    /**
     * Get Meal value
     * @return \room\StructType\Meal[]|null
     */
    public function getMeal()
    {
        return $this->Meal;
    }
    /**
     * This method is responsible for validating the values passed to the setMeal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMealForArrayConstraintsFromSetMeal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mealsTypeMealItem) {
            // validation for constraint: itemType
            if (!$mealsTypeMealItem instanceof \room\StructType\Meal) {
                $invalidValues[] = is_object($mealsTypeMealItem) ? get_class($mealsTypeMealItem) : sprintf('%s(%s)', gettype($mealsTypeMealItem), var_export($mealsTypeMealItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Meal property can only contain items of type \room\StructType\Meal, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Meal value
     * @throws \InvalidArgumentException
     * @param \room\StructType\Meal[] $meal
     * @return \room\StructType\MealsType
     */
    public function setMeal(array $meal = array())
    {
        // validation for constraint: array
        if ('' !== ($mealArrayErrorMessage = self::validateMealForArrayConstraintsFromSetMeal($meal))) {
            throw new \InvalidArgumentException($mealArrayErrorMessage, __LINE__);
        }
        $this->Meal = $meal;
        return $this;
    }
    /**
     * Add item to Meal value
     * @throws \InvalidArgumentException
     * @param \room\StructType\Meal $item
     * @return \room\StructType\MealsType
     */
    public function addToMeal(\room\StructType\Meal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\Meal) {
            throw new \InvalidArgumentException(sprintf('The Meal property can only contain items of type \room\StructType\Meal, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Meal[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\MealsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
