<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeProfileRQ StructType
 * @subpackage Structs
 */
class MakeProfileRQ extends AbstractStructBase
{
    /**
     * The HotelRef
     * @var \room\StructType\HotelRefType
     */
    public $HotelRef;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The Profile
     * @var \room\StructType\ProfileType
     */
    public $Profile;
    /**
     * The Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The Lang
     * @var string
     */
    public $Lang;
    /**
     * The Debug
     * @var bool
     */
    public $Debug;
    /**
     * Constructor method for MakeProfileRQ
     * @uses MakeProfileRQ::setHotelRef()
     * @uses MakeProfileRQ::setPassword()
     * @uses MakeProfileRQ::setProfile()
     * @uses MakeProfileRQ::setTimestamp()
     * @uses MakeProfileRQ::setVersion()
     * @uses MakeProfileRQ::setLang()
     * @uses MakeProfileRQ::setDebug()
     * @param \room\StructType\HotelRefType $hotelRef
     * @param string $password
     * @param \room\StructType\ProfileType $profile
     * @param string $timestamp
     * @param float $version
     * @param string $lang
     * @param bool $debug
     */
    public function __construct(\room\StructType\HotelRefType $hotelRef = null, $password = null, \room\StructType\ProfileType $profile = null, $timestamp = null, $version = null, $lang = null, $debug = null)
    {
        $this
            ->setHotelRef($hotelRef)
            ->setPassword($password)
            ->setProfile($profile)
            ->setTimestamp($timestamp)
            ->setVersion($version)
            ->setLang($lang)
            ->setDebug($debug);
    }
    /**
     * Get HotelRef value
     * @return \room\StructType\HotelRefType|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \room\StructType\HotelRefType $hotelRef
     * @return \room\StructType\MakeProfileRQ
     */
    public function setHotelRef(\room\StructType\HotelRefType $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \room\StructType\MakeProfileRQ
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Profile value
     * @return \room\StructType\ProfileType|null
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * Set Profile value
     * @param \room\StructType\ProfileType $profile
     * @return \room\StructType\MakeProfileRQ
     */
    public function setProfile(\room\StructType\ProfileType $profile = null)
    {
        $this->Profile = $profile;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \room\StructType\MakeProfileRQ
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \room\StructType\MakeProfileRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->Lang;
    }
    /**
     * Set Lang value
     * @param string $lang
     * @return \room\StructType\MakeProfileRQ
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->Lang = $lang;
        return $this;
    }
    /**
     * Get Debug value
     * @return bool|null
     */
    public function getDebug()
    {
        return $this->Debug;
    }
    /**
     * Set Debug value
     * @param bool $debug
     * @return \room\StructType\MakeProfileRQ
     */
    public function setDebug($debug = null)
    {
        // validation for constraint: boolean
        if (!is_null($debug) && !is_bool($debug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($debug, true), gettype($debug)), __LINE__);
        }
        $this->Debug = $debug;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\MakeProfileRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
