<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageType StructType
 * @subpackage Structs
 */
class ImageType extends AbstractStructBase
{
    /**
     * The URL
     * @var string
     */
    public $URL;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DescriptionType
     */
    public $Description;
    /**
     * Constructor method for ImageType
     * @uses ImageType::setURL()
     * @uses ImageType::setDescription()
     * @param string $uRL
     * @param \room\StructType\DescriptionType $description
     */
    public function __construct($uRL = null, \room\StructType\DescriptionType $description = null)
    {
        $this
            ->setURL($uRL)
            ->setDescription($description);
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \room\StructType\ImageType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get Description value
     * @return \room\StructType\DescriptionType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \room\StructType\DescriptionType $description
     * @return \room\StructType\ImageType
     */
    public function setDescription(\room\StructType\DescriptionType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\ImageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
