<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelsType StructType
 * @subpackage Structs
 */
class HotelsType extends AbstractStructBase
{
    /**
     * The Hotel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \room\StructType\HotelType[]
     */
    public $Hotel;
    /**
     * Constructor method for HotelsType
     * @uses HotelsType::setHotel()
     * @param \room\StructType\HotelType[] $hotel
     */
    public function __construct(array $hotel = array())
    {
        $this
            ->setHotel($hotel);
    }
    /**
     * Get Hotel value
     * @return \room\StructType\HotelType[]|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelForArrayConstraintsFromSetHotel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelsTypeHotelItem) {
            // validation for constraint: itemType
            if (!$hotelsTypeHotelItem instanceof \room\StructType\HotelType) {
                $invalidValues[] = is_object($hotelsTypeHotelItem) ? get_class($hotelsTypeHotelItem) : sprintf('%s(%s)', gettype($hotelsTypeHotelItem), var_export($hotelsTypeHotelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel property can only contain items of type \room\StructType\HotelType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel value
     * @throws \InvalidArgumentException
     * @param \room\StructType\HotelType[] $hotel
     * @return \room\StructType\HotelsType
     */
    public function setHotel(array $hotel = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelArrayErrorMessage = self::validateHotelForArrayConstraintsFromSetHotel($hotel))) {
            throw new \InvalidArgumentException($hotelArrayErrorMessage, __LINE__);
        }
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \room\StructType\HotelType $item
     * @return \room\StructType\HotelsType
     */
    public function addToHotel(\room\StructType\HotelType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\HotelType) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of type \room\StructType\HotelType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\HotelsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
