<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelType StructType
 * @subpackage Structs
 */
class HotelType extends AbstractStructBase
{
    /**
     * The HotelCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $HotelCode;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Address
     * @var \room\StructType\AddressType
     */
    public $Address;
    /**
     * The ImageURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImageURL;
    /**
     * The BrandImageURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BrandImageURL;
    /**
     * The Description
     * @var \room\StructType\DescriptionType
     */
    public $Description;
    /**
     * The Rating
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RatingType
     */
    public $Rating;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Distance;
    /**
     * The Availability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\BestPriceAvailabilityType
     */
    public $Availability;
    /**
     * Constructor method for HotelType
     * @uses HotelType::setHotelCode()
     * @uses HotelType::setName()
     * @uses HotelType::setAddress()
     * @uses HotelType::setImageURL()
     * @uses HotelType::setBrandImageURL()
     * @uses HotelType::setDescription()
     * @uses HotelType::setRating()
     * @uses HotelType::setDistance()
     * @uses HotelType::setAvailability()
     * @param string $hotelCode
     * @param string $name
     * @param \room\StructType\AddressType $address
     * @param string $imageURL
     * @param string $brandImageURL
     * @param \room\StructType\DescriptionType $description
     * @param \room\StructType\RatingType $rating
     * @param float $distance
     * @param \room\StructType\BestPriceAvailabilityType $availability
     */
    public function __construct($hotelCode = null, $name = null, \room\StructType\AddressType $address = null, $imageURL = null, $brandImageURL = null, \room\StructType\DescriptionType $description = null, \room\StructType\RatingType $rating = null, $distance = null, \room\StructType\BestPriceAvailabilityType $availability = null)
    {
        $this
            ->setHotelCode($hotelCode)
            ->setName($name)
            ->setAddress($address)
            ->setImageURL($imageURL)
            ->setBrandImageURL($brandImageURL)
            ->setDescription($description)
            ->setRating($rating)
            ->setDistance($distance)
            ->setAvailability($availability);
    }
    /**
     * Get HotelCode value
     * @return string
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \room\StructType\HotelType
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \room\StructType\HotelType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return \room\StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \room\StructType\AddressType $address
     * @return \room\StructType\HotelType
     */
    public function setAddress(\room\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ImageURL value
     * @return string|null
     */
    public function getImageURL()
    {
        return $this->ImageURL;
    }
    /**
     * Set ImageURL value
     * @param string $imageURL
     * @return \room\StructType\HotelType
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageURL, true), gettype($imageURL)), __LINE__);
        }
        $this->ImageURL = $imageURL;
        return $this;
    }
    /**
     * Get BrandImageURL value
     * @return string|null
     */
    public function getBrandImageURL()
    {
        return $this->BrandImageURL;
    }
    /**
     * Set BrandImageURL value
     * @param string $brandImageURL
     * @return \room\StructType\HotelType
     */
    public function setBrandImageURL($brandImageURL = null)
    {
        // validation for constraint: string
        if (!is_null($brandImageURL) && !is_string($brandImageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandImageURL, true), gettype($brandImageURL)), __LINE__);
        }
        $this->BrandImageURL = $brandImageURL;
        return $this;
    }
    /**
     * Get Description value
     * @return \room\StructType\DescriptionType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \room\StructType\DescriptionType $description
     * @return \room\StructType\HotelType
     */
    public function setDescription(\room\StructType\DescriptionType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Rating value
     * @return \room\StructType\RatingType|null
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @param \room\StructType\RatingType $rating
     * @return \room\StructType\HotelType
     */
    public function setRating(\room\StructType\RatingType $rating = null)
    {
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Get Distance value
     * @return float|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param float $distance
     * @return \room\StructType\HotelType
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: float
        if (!is_null($distance) && !(is_float($distance) || is_numeric($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Availability value
     * @return \room\StructType\BestPriceAvailabilityType|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param \room\StructType\BestPriceAvailabilityType $availability
     * @return \room\StructType\HotelType
     */
    public function setAvailability(\room\StructType\BestPriceAvailabilityType $availability = null)
    {
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\HotelType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
