<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelImagesType StructType
 * @subpackage Structs
 */
class HotelImagesType extends AbstractStructBase
{
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \room\StructType\ImageType[]
     */
    public $Image;
    /**
     * Constructor method for HotelImagesType
     * @uses HotelImagesType::setImage()
     * @param \room\StructType\ImageType[] $image
     */
    public function __construct(array $image = array())
    {
        $this
            ->setImage($image);
    }
    /**
     * Get Image value
     * @return \room\StructType\ImageType[]|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * This method is responsible for validating the values passed to the setImage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageForArrayConstraintsFromSetImage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelImagesTypeImageItem) {
            // validation for constraint: itemType
            if (!$hotelImagesTypeImageItem instanceof \room\StructType\ImageType) {
                $invalidValues[] = is_object($hotelImagesTypeImageItem) ? get_class($hotelImagesTypeImageItem) : sprintf('%s(%s)', gettype($hotelImagesTypeImageItem), var_export($hotelImagesTypeImageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Image property can only contain items of type \room\StructType\ImageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Image value
     * @throws \InvalidArgumentException
     * @param \room\StructType\ImageType[] $image
     * @return \room\StructType\HotelImagesType
     */
    public function setImage(array $image = array())
    {
        // validation for constraint: array
        if ('' !== ($imageArrayErrorMessage = self::validateImageForArrayConstraintsFromSetImage($image))) {
            throw new \InvalidArgumentException($imageArrayErrorMessage, __LINE__);
        }
        $this->Image = $image;
        return $this;
    }
    /**
     * Add item to Image value
     * @throws \InvalidArgumentException
     * @param \room\StructType\ImageType $item
     * @return \room\StructType\HotelImagesType
     */
    public function addToImage(\room\StructType\ImageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\ImageType) {
            throw new \InvalidArgumentException(sprintf('The Image property can only contain items of type \room\StructType\ImageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Image[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\HotelImagesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
