<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestCountType StructType
 * @subpackage Structs
 */
class GuestCountType extends AbstractStructBase
{
    /**
     * The AgeQualifyingCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Count;
    /**
     * Constructor method for GuestCountType
     * @uses GuestCountType::setAgeQualifyingCode()
     * @uses GuestCountType::setCount()
     * @param string $ageQualifyingCode
     * @param int $count
     */
    public function __construct($ageQualifyingCode = null, $count = null)
    {
        $this
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setCount($count);
    }
    /**
     * Get AgeQualifyingCode value
     * @return string
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \room\StructType\GuestCountType
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get Count value
     * @return int
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \room\StructType\GuestCountType
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\GuestCountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
