<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetObmConfigRQ StructType
 * @subpackage Structs
 */
class GetObmConfigRQ extends AbstractStructBase
{
    /**
     * The HotelGroupCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HotelGroupCode;
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\HotelRefType
     */
    public $HotelRef;
    /**
     * The Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The Lang
     * @var string
     */
    public $Lang;
    /**
     * The Debug
     * @var bool
     */
    public $Debug;
    /**
     * Constructor method for GetObmConfigRQ
     * @uses GetObmConfigRQ::setHotelGroupCode()
     * @uses GetObmConfigRQ::setHotelRef()
     * @uses GetObmConfigRQ::setTimestamp()
     * @uses GetObmConfigRQ::setVersion()
     * @uses GetObmConfigRQ::setLang()
     * @uses GetObmConfigRQ::setDebug()
     * @param string $hotelGroupCode
     * @param \room\StructType\HotelRefType $hotelRef
     * @param string $timestamp
     * @param float $version
     * @param string $lang
     * @param bool $debug
     */
    public function __construct($hotelGroupCode = null, \room\StructType\HotelRefType $hotelRef = null, $timestamp = null, $version = null, $lang = null, $debug = null)
    {
        $this
            ->setHotelGroupCode($hotelGroupCode)
            ->setHotelRef($hotelRef)
            ->setTimestamp($timestamp)
            ->setVersion($version)
            ->setLang($lang)
            ->setDebug($debug);
    }
    /**
     * Get HotelGroupCode value
     * @return string|null
     */
    public function getHotelGroupCode()
    {
        return $this->HotelGroupCode;
    }
    /**
     * Set HotelGroupCode value
     * @param string $hotelGroupCode
     * @return \room\StructType\GetObmConfigRQ
     */
    public function setHotelGroupCode($hotelGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelGroupCode) && !is_string($hotelGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelGroupCode, true), gettype($hotelGroupCode)), __LINE__);
        }
        $this->HotelGroupCode = $hotelGroupCode;
        return $this;
    }
    /**
     * Get HotelRef value
     * @return \room\StructType\HotelRefType|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \room\StructType\HotelRefType $hotelRef
     * @return \room\StructType\GetObmConfigRQ
     */
    public function setHotelRef(\room\StructType\HotelRefType $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \room\StructType\GetObmConfigRQ
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \room\StructType\GetObmConfigRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->Lang;
    }
    /**
     * Set Lang value
     * @param string $lang
     * @return \room\StructType\GetObmConfigRQ
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->Lang = $lang;
        return $this;
    }
    /**
     * Get Debug value
     * @return bool|null
     */
    public function getDebug()
    {
        return $this->Debug;
    }
    /**
     * Set Debug value
     * @param bool $debug
     * @return \room\StructType\GetObmConfigRQ
     */
    public function setDebug($debug = null)
    {
        // validation for constraint: boolean
        if (!is_null($debug) && !is_bool($debug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($debug, true), gettype($debug)), __LINE__);
        }
        $this->Debug = $debug;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\GetObmConfigRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
