<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHotelsRQ StructType
 * @subpackage Structs
 */
class GetHotelsRQ extends AbstractStructBase
{
    /**
     * The HotelGroupCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HotelGroupCode;
    /**
     * The HotelList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\HotelListType
     */
    public $HotelList;
    /**
     * The LocationFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\LocationFilterType
     */
    public $LocationFilter;
    /**
     * The StayDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\StayDetailsType
     */
    public $StayDetails;
    /**
     * The MaxResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxResults;
    /**
     * The HotelFacilitiesFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HotelFacilitiesFilter;
    /**
     * The ReturnAvailability
     * @var bool
     */
    public $ReturnAvailability;
    /**
     * The Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The Lang
     * @var string
     */
    public $Lang;
    /**
     * The Debug
     * @var bool
     */
    public $Debug;
    /**
     * Constructor method for GetHotelsRQ
     * @uses GetHotelsRQ::setHotelGroupCode()
     * @uses GetHotelsRQ::setHotelList()
     * @uses GetHotelsRQ::setLocationFilter()
     * @uses GetHotelsRQ::setStayDetails()
     * @uses GetHotelsRQ::setMaxResults()
     * @uses GetHotelsRQ::setHotelFacilitiesFilter()
     * @uses GetHotelsRQ::setReturnAvailability()
     * @uses GetHotelsRQ::setTimestamp()
     * @uses GetHotelsRQ::setVersion()
     * @uses GetHotelsRQ::setLang()
     * @uses GetHotelsRQ::setDebug()
     * @param string $hotelGroupCode
     * @param \room\StructType\HotelListType $hotelList
     * @param \room\StructType\LocationFilterType $locationFilter
     * @param \room\StructType\StayDetailsType $stayDetails
     * @param int $maxResults
     * @param string $hotelFacilitiesFilter
     * @param bool $returnAvailability
     * @param string $timestamp
     * @param float $version
     * @param string $lang
     * @param bool $debug
     */
    public function __construct($hotelGroupCode = null, \room\StructType\HotelListType $hotelList = null, \room\StructType\LocationFilterType $locationFilter = null, \room\StructType\StayDetailsType $stayDetails = null, $maxResults = null, $hotelFacilitiesFilter = null, $returnAvailability = null, $timestamp = null, $version = null, $lang = null, $debug = null)
    {
        $this
            ->setHotelGroupCode($hotelGroupCode)
            ->setHotelList($hotelList)
            ->setLocationFilter($locationFilter)
            ->setStayDetails($stayDetails)
            ->setMaxResults($maxResults)
            ->setHotelFacilitiesFilter($hotelFacilitiesFilter)
            ->setReturnAvailability($returnAvailability)
            ->setTimestamp($timestamp)
            ->setVersion($version)
            ->setLang($lang)
            ->setDebug($debug);
    }
    /**
     * Get HotelGroupCode value
     * @return string|null
     */
    public function getHotelGroupCode()
    {
        return $this->HotelGroupCode;
    }
    /**
     * Set HotelGroupCode value
     * @param string $hotelGroupCode
     * @return \room\StructType\GetHotelsRQ
     */
    public function setHotelGroupCode($hotelGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelGroupCode) && !is_string($hotelGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelGroupCode, true), gettype($hotelGroupCode)), __LINE__);
        }
        $this->HotelGroupCode = $hotelGroupCode;
        return $this;
    }
    /**
     * Get HotelList value
     * @return \room\StructType\HotelListType|null
     */
    public function getHotelList()
    {
        return $this->HotelList;
    }
    /**
     * Set HotelList value
     * @param \room\StructType\HotelListType $hotelList
     * @return \room\StructType\GetHotelsRQ
     */
    public function setHotelList(\room\StructType\HotelListType $hotelList = null)
    {
        $this->HotelList = $hotelList;
        return $this;
    }
    /**
     * Get LocationFilter value
     * @return \room\StructType\LocationFilterType|null
     */
    public function getLocationFilter()
    {
        return $this->LocationFilter;
    }
    /**
     * Set LocationFilter value
     * @param \room\StructType\LocationFilterType $locationFilter
     * @return \room\StructType\GetHotelsRQ
     */
    public function setLocationFilter(\room\StructType\LocationFilterType $locationFilter = null)
    {
        $this->LocationFilter = $locationFilter;
        return $this;
    }
    /**
     * Get StayDetails value
     * @return \room\StructType\StayDetailsType|null
     */
    public function getStayDetails()
    {
        return $this->StayDetails;
    }
    /**
     * Set StayDetails value
     * @param \room\StructType\StayDetailsType $stayDetails
     * @return \room\StructType\GetHotelsRQ
     */
    public function setStayDetails(\room\StructType\StayDetailsType $stayDetails = null)
    {
        $this->StayDetails = $stayDetails;
        return $this;
    }
    /**
     * Get MaxResults value
     * @return int|null
     */
    public function getMaxResults()
    {
        return $this->MaxResults;
    }
    /**
     * Set MaxResults value
     * @param int $maxResults
     * @return \room\StructType\GetHotelsRQ
     */
    public function setMaxResults($maxResults = null)
    {
        // validation for constraint: int
        if (!is_null($maxResults) && !(is_int($maxResults) || ctype_digit($maxResults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxResults, true), gettype($maxResults)), __LINE__);
        }
        $this->MaxResults = $maxResults;
        return $this;
    }
    /**
     * Get HotelFacilitiesFilter value
     * @return string|null
     */
    public function getHotelFacilitiesFilter()
    {
        return $this->HotelFacilitiesFilter;
    }
    /**
     * Set HotelFacilitiesFilter value
     * @param string $hotelFacilitiesFilter
     * @return \room\StructType\GetHotelsRQ
     */
    public function setHotelFacilitiesFilter($hotelFacilitiesFilter = null)
    {
        // validation for constraint: string
        if (!is_null($hotelFacilitiesFilter) && !is_string($hotelFacilitiesFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelFacilitiesFilter, true), gettype($hotelFacilitiesFilter)), __LINE__);
        }
        $this->HotelFacilitiesFilter = $hotelFacilitiesFilter;
        return $this;
    }
    /**
     * Get ReturnAvailability value
     * @return bool|null
     */
    public function getReturnAvailability()
    {
        return $this->ReturnAvailability;
    }
    /**
     * Set ReturnAvailability value
     * @param bool $returnAvailability
     * @return \room\StructType\GetHotelsRQ
     */
    public function setReturnAvailability($returnAvailability = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnAvailability) && !is_bool($returnAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnAvailability, true), gettype($returnAvailability)), __LINE__);
        }
        $this->ReturnAvailability = $returnAvailability;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \room\StructType\GetHotelsRQ
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \room\StructType\GetHotelsRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->Lang;
    }
    /**
     * Set Lang value
     * @param string $lang
     * @return \room\StructType\GetHotelsRQ
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->Lang = $lang;
        return $this;
    }
    /**
     * Get Debug value
     * @return bool|null
     */
    public function getDebug()
    {
        return $this->Debug;
    }
    /**
     * Set Debug value
     * @param bool $debug
     * @return \room\StructType\GetHotelsRQ
     */
    public function setDebug($debug = null)
    {
        // validation for constraint: boolean
        if (!is_null($debug) && !is_bool($debug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($debug, true), gettype($debug)), __LINE__);
        }
        $this->Debug = $debug;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\GetHotelsRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
