<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DailyAvailabilitiesType StructType
 * @subpackage Structs
 */
class DailyAvailabilitiesType extends AbstractStructBase
{
    /**
     * The Availability
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \room\StructType\AvailabilityType[]
     */
    public $Availability;
    /**
     * Constructor method for DailyAvailabilitiesType
     * @uses DailyAvailabilitiesType::setAvailability()
     * @param \room\StructType\AvailabilityType[] $availability
     */
    public function __construct(array $availability = array())
    {
        $this
            ->setAvailability($availability);
    }
    /**
     * Get Availability value
     * @return \room\StructType\AvailabilityType[]|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * This method is responsible for validating the values passed to the setAvailability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailability method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvailabilityForArrayConstraintsFromSetAvailability(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dailyAvailabilitiesTypeAvailabilityItem) {
            // validation for constraint: itemType
            if (!$dailyAvailabilitiesTypeAvailabilityItem instanceof \room\StructType\AvailabilityType) {
                $invalidValues[] = is_object($dailyAvailabilitiesTypeAvailabilityItem) ? get_class($dailyAvailabilitiesTypeAvailabilityItem) : sprintf('%s(%s)', gettype($dailyAvailabilitiesTypeAvailabilityItem), var_export($dailyAvailabilitiesTypeAvailabilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Availability property can only contain items of type \room\StructType\AvailabilityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Availability value
     * @throws \InvalidArgumentException
     * @param \room\StructType\AvailabilityType[] $availability
     * @return \room\StructType\DailyAvailabilitiesType
     */
    public function setAvailability(array $availability = array())
    {
        // validation for constraint: array
        if ('' !== ($availabilityArrayErrorMessage = self::validateAvailabilityForArrayConstraintsFromSetAvailability($availability))) {
            throw new \InvalidArgumentException($availabilityArrayErrorMessage, __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Add item to Availability value
     * @throws \InvalidArgumentException
     * @param \room\StructType\AvailabilityType $item
     * @return \room\StructType\DailyAvailabilitiesType
     */
    public function addToAvailability(\room\StructType\AvailabilityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\AvailabilityType) {
            throw new \InvalidArgumentException(sprintf('The Availability property can only contain items of type \room\StructType\AvailabilityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Availability[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\DailyAvailabilitiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
