<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyType StructType
 * @subpackage Structs
 */
class CompanyType extends AbstractStructBase
{
    /**
     * The CompanyRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CompanyRef;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The ABTA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ABTA;
    /**
     * The ATOL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ATOL;
    /**
     * The IATA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IATA;
    /**
     * Constructor method for CompanyType
     * @uses CompanyType::setCompanyRef()
     * @uses CompanyType::setName()
     * @uses CompanyType::setABTA()
     * @uses CompanyType::setATOL()
     * @uses CompanyType::setIATA()
     * @param string $companyRef
     * @param string $name
     * @param string $aBTA
     * @param string $aTOL
     * @param string $iATA
     */
    public function __construct($companyRef = null, $name = null, $aBTA = null, $aTOL = null, $iATA = null)
    {
        $this
            ->setCompanyRef($companyRef)
            ->setName($name)
            ->setABTA($aBTA)
            ->setATOL($aTOL)
            ->setIATA($iATA);
    }
    /**
     * Get CompanyRef value
     * @return string|null
     */
    public function getCompanyRef()
    {
        return $this->CompanyRef;
    }
    /**
     * Set CompanyRef value
     * @param string $companyRef
     * @return \room\StructType\CompanyType
     */
    public function setCompanyRef($companyRef = null)
    {
        // validation for constraint: string
        if (!is_null($companyRef) && !is_string($companyRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyRef, true), gettype($companyRef)), __LINE__);
        }
        $this->CompanyRef = $companyRef;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \room\StructType\CompanyType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ABTA value
     * @return string|null
     */
    public function getABTA()
    {
        return $this->ABTA;
    }
    /**
     * Set ABTA value
     * @param string $aBTA
     * @return \room\StructType\CompanyType
     */
    public function setABTA($aBTA = null)
    {
        // validation for constraint: string
        if (!is_null($aBTA) && !is_string($aBTA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aBTA, true), gettype($aBTA)), __LINE__);
        }
        $this->ABTA = $aBTA;
        return $this;
    }
    /**
     * Get ATOL value
     * @return string|null
     */
    public function getATOL()
    {
        return $this->ATOL;
    }
    /**
     * Set ATOL value
     * @param string $aTOL
     * @return \room\StructType\CompanyType
     */
    public function setATOL($aTOL = null)
    {
        // validation for constraint: string
        if (!is_null($aTOL) && !is_string($aTOL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aTOL, true), gettype($aTOL)), __LINE__);
        }
        $this->ATOL = $aTOL;
        return $this;
    }
    /**
     * Get IATA value
     * @return string|null
     */
    public function getIATA()
    {
        return $this->IATA;
    }
    /**
     * Set IATA value
     * @param string $iATA
     * @return \room\StructType\CompanyType
     */
    public function setIATA($iATA = null)
    {
        // validation for constraint: string
        if (!is_null($iATA) && !is_string($iATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA, true), gettype($iATA)), __LINE__);
        }
        $this->IATA = $iATA;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\CompanyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
