<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancellationPolicyType StructType
 * @subpackage Structs
 */
class CancellationPolicyType extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Penalty
     * @var \room\StructType\PenaltyType
     */
    public $Penalty;
    /**
     * The DaysPriorToArrival
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DaysPriorToArrival;
    /**
     * The Hour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Hour;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DescriptionType
     */
    public $Text;
    /**
     * Constructor method for CancellationPolicyType
     * @uses CancellationPolicyType::setName()
     * @uses CancellationPolicyType::setPenalty()
     * @uses CancellationPolicyType::setDaysPriorToArrival()
     * @uses CancellationPolicyType::setHour()
     * @uses CancellationPolicyType::setText()
     * @param string $name
     * @param \room\StructType\PenaltyType $penalty
     * @param int $daysPriorToArrival
     * @param string $hour
     * @param \room\StructType\DescriptionType $text
     */
    public function __construct($name = null, \room\StructType\PenaltyType $penalty = null, $daysPriorToArrival = null, $hour = null, \room\StructType\DescriptionType $text = null)
    {
        $this
            ->setName($name)
            ->setPenalty($penalty)
            ->setDaysPriorToArrival($daysPriorToArrival)
            ->setHour($hour)
            ->setText($text);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \room\StructType\CancellationPolicyType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Penalty value
     * @return \room\StructType\PenaltyType|null
     */
    public function getPenalty()
    {
        return $this->Penalty;
    }
    /**
     * Set Penalty value
     * @param \room\StructType\PenaltyType $penalty
     * @return \room\StructType\CancellationPolicyType
     */
    public function setPenalty(\room\StructType\PenaltyType $penalty = null)
    {
        $this->Penalty = $penalty;
        return $this;
    }
    /**
     * Get DaysPriorToArrival value
     * @return int|null
     */
    public function getDaysPriorToArrival()
    {
        return $this->DaysPriorToArrival;
    }
    /**
     * Set DaysPriorToArrival value
     * @param int $daysPriorToArrival
     * @return \room\StructType\CancellationPolicyType
     */
    public function setDaysPriorToArrival($daysPriorToArrival = null)
    {
        // validation for constraint: int
        if (!is_null($daysPriorToArrival) && !(is_int($daysPriorToArrival) || ctype_digit($daysPriorToArrival))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($daysPriorToArrival, true), gettype($daysPriorToArrival)), __LINE__);
        }
        $this->DaysPriorToArrival = $daysPriorToArrival;
        return $this;
    }
    /**
     * Get Hour value
     * @return string|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param string $hour
     * @return \room\StructType\CancellationPolicyType
     */
    public function setHour($hour = null)
    {
        // validation for constraint: string
        if (!is_null($hour) && !is_string($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hour, true), gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get Text value
     * @return \room\StructType\DescriptionType|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param \room\StructType\DescriptionType $text
     * @return \room\StructType\CancellationPolicyType
     */
    public function setText(\room\StructType\DescriptionType $text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\CancellationPolicyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
