<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Auth StructType
 * @subpackage Structs
 */
class Auth extends AbstractStructBase
{
    /**
     * The FromSystemId
     * @var \room\StructType\FromSystemId
     */
    public $FromSystemId;
    /**
     * The UserName
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * Constructor method for Auth
     * @uses Auth::setFromSystemId()
     * @uses Auth::setUserName()
     * @uses Auth::setPassword()
     * @param \room\StructType\FromSystemId $fromSystemId
     * @param string $userName
     * @param string $password
     */
    public function __construct(\room\StructType\FromSystemId $fromSystemId = null, $userName = null, $password = null)
    {
        $this
            ->setFromSystemId($fromSystemId)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get FromSystemId value
     * @return \room\StructType\FromSystemId|null
     */
    public function getFromSystemId()
    {
        return $this->FromSystemId;
    }
    /**
     * Set FromSystemId value
     * @param \room\StructType\FromSystemId $fromSystemId
     * @return \room\StructType\Auth
     */
    public function setFromSystemId(\room\StructType\FromSystemId $fromSystemId = null)
    {
        $this->FromSystemId = $fromSystemId;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \room\StructType\Auth
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \room\StructType\Auth
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\Auth
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
