<?php

namespace room\EnumType;

/**
 * This class stands for PrePaymentTypeType EnumType
 * @subpackage Enumerations
 */
class PrePaymentTypeType
{
    /**
     * Constant for value 'Reserve'
     * @return string 'Reserve'
     */
    const VALUE_RESERVE = 'Reserve';
    /**
     * Constant for value 'Deposit'
     * @return string 'Deposit'
     */
    const VALUE_DEPOSIT = 'Deposit';
    /**
     * Constant for value 'Pay now'
     * @return string 'Pay now'
     */
    const VALUE_PAY_NOW = 'Pay now';
    /**
     * Constant for value 'First night'
     * @return string 'First night'
     */
    const VALUE_FIRST_NIGHT = 'First night';
    /**
     * Constant for value 'Per adult'
     * @return string 'Per adult'
     */
    const VALUE_PER_ADULT = 'Per adult';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RESERVE
     * @uses self::VALUE_DEPOSIT
     * @uses self::VALUE_PAY_NOW
     * @uses self::VALUE_FIRST_NIGHT
     * @uses self::VALUE_PER_ADULT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RESERVE,
            self::VALUE_DEPOSIT,
            self::VALUE_PAY_NOW,
            self::VALUE_FIRST_NIGHT,
            self::VALUE_PER_ADULT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
