<?php

namespace room\EnumType;

/**
 * This class stands for PenaltyCodeType EnumType
 * @subpackage Enumerations
 */
class PenaltyCodeType
{
    /**
     * Constant for value 'Fixed'
     * @return string 'Fixed'
     */
    const VALUE_FIXED = 'Fixed';
    /**
     * Constant for value 'Non cancelable'
     * @return string 'Non cancelable'
     */
    const VALUE_NON_CANCELABLE = 'Non cancelable';
    /**
     * Constant for value 'Percentage'
     * @return string 'Percentage'
     */
    const VALUE_PERCENTAGE = 'Percentage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIXED
     * @uses self::VALUE_NON_CANCELABLE
     * @uses self::VALUE_PERCENTAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIXED,
            self::VALUE_NON_CANCELABLE,
            self::VALUE_PERCENTAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
