<?php

namespace room\EnumType;

/**
 * This class stands for PaymentStatusType EnumType
 * @subpackage Enumerations
 */
class PaymentStatusType
{
    /**
     * Constant for value 'Finished'
     * @return string 'Finished'
     */
    const VALUE_FINISHED = 'Finished';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'NotStarted'
     * @return string 'NotStarted'
     */
    const VALUE_NOT_STARTED = 'NotStarted';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FINISHED
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_NOT_STARTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FINISHED,
            self::VALUE_PENDING,
            self::VALUE_NOT_STARTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
