<?php

namespace room\EnumType;

/**
 * This class stands for FreeNightType EnumType
 * @subpackage Enumerations
 */
class FreeNightType
{
    /**
     * Constant for value 'TwoForOne'
     * @return string 'TwoForOne'
     */
    const VALUE_TWO_FOR_ONE = 'TwoForOne';
    /**
     * Constant for value 'ThreeForTwo'
     * @return string 'ThreeForTwo'
     */
    const VALUE_THREE_FOR_TWO = 'ThreeForTwo';
    /**
     * Constant for value 'ForForThree'
     * @return string 'ForForThree'
     */
    const VALUE_FOR_FOR_THREE = 'ForForThree';
    /**
     * Constant for value 'FiveForFor'
     * @return string 'FiveForFor'
     */
    const VALUE_FIVE_FOR_FOR = 'FiveForFor';
    /**
     * Constant for value 'SixForFive'
     * @return string 'SixForFive'
     */
    const VALUE_SIX_FOR_FIVE = 'SixForFive';
    /**
     * Constant for value 'SevenForSix'
     * @return string 'SevenForSix'
     */
    const VALUE_SEVEN_FOR_SIX = 'SevenForSix';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TWO_FOR_ONE
     * @uses self::VALUE_THREE_FOR_TWO
     * @uses self::VALUE_FOR_FOR_THREE
     * @uses self::VALUE_FIVE_FOR_FOR
     * @uses self::VALUE_SIX_FOR_FIVE
     * @uses self::VALUE_SEVEN_FOR_SIX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TWO_FOR_ONE,
            self::VALUE_THREE_FOR_TWO,
            self::VALUE_FOR_FOR_THREE,
            self::VALUE_FIVE_FOR_FOR,
            self::VALUE_SIX_FOR_FIVE,
            self::VALUE_SEVEN_FOR_SIX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
