<?php

namespace room\EnumType;

/**
 * This class stands for AdjustmentType EnumType
 * @subpackage Enumerations
 */
class AdjustmentType
{
    /**
     * Constant for value 'Amount'
     * @return string 'Amount'
     */
    const VALUE_AMOUNT = 'Amount';
    /**
     * Constant for value 'Flat'
     * @return string 'Flat'
     */
    const VALUE_FLAT = 'Flat';
    /**
     * Constant for value 'Percentage'
     * @return string 'Percentage'
     */
    const VALUE_PERCENTAGE = 'Percentage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AMOUNT
     * @uses self::VALUE_FLAT
     * @uses self::VALUE_PERCENTAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AMOUNT,
            self::VALUE_FLAT,
            self::VALUE_PERCENTAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
