<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://uk2.roomlynx.net/guestlinedistributionengine/RoomLynxAPIPortTypeImpl?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://uk2.roomlynx.net/guestlinedistributionengine/RoomLynxAPIPortTypeImpl?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \room\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \room\ServiceType\Get($options);
$get->setSoapHeaderAuth(new \room\StructType\Auth());
/**
 * Sample call for GetCountries operation/method
 */
if ($get->GetCountries(new \room\StructType\GetCountriesRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHotels operation/method
 */
if ($get->GetHotels(new \room\StructType\GetHotelsRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailability operation/method
 */
if ($get->GetAvailability(new \room\StructType\GetAvailabilityRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProfileV2 operation/method
 */
if ($get->GetProfileV2(new \room\StructType\GetProfileV2RQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReservation operation/method
 */
if ($get->GetReservation(new \room\StructType\GetReservationRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetObmConfig operation/method
 */
if ($get->GetObmConfig(new \room\StructType\GetObmConfigRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUpsells operation/method
 */
if ($get->GetUpsells(new \room\StructType\GetUpsellsRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHotelDetails operation/method
 */
if ($get->GetHotelDetails(new \room\StructType\GetHotelDetailsRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRegions operation/method
 */
if ($get->GetRegions(new \room\StructType\GetRegionsRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLosRules operation/method
 */
if ($get->GetLosRules(new \room\StructType\GetLosRulesRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRooms operation/method
 */
if ($get->GetRooms(new \room\StructType\GetRoomsRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRates operation/method
 */
if ($get->GetRates(new \room\StructType\GetRatesRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyAccount operation/method
 */
if ($get->GetCompanyAccount(new \room\StructType\GetCompanyAccountRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProfile operation/method
 */
if ($get->GetProfile(new \room\StructType\GetProfileRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \room\ServiceType\Send($options);
$send->setSoapHeaderAuth(new \room\StructType\Auth());
/**
 * Sample call for SendProfilePassword operation/method
 */
if ($send->SendProfilePassword(new \room\StructType\SendProfilePasswordRQ()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Make ServiceType
 */
$make = new \room\ServiceType\Make($options);
$make->setSoapHeaderAuth(new \room\StructType\Auth());
/**
 * Sample call for MakeProfile operation/method
 */
if ($make->MakeProfile(new \room\StructType\MakeProfileRQ()) !== false) {
    print_r($make->getResult());
} else {
    print_r($make->getLastError());
}
/**
 * Sample call for MakeReservation operation/method
 */
if ($make->MakeReservation(new \room\StructType\MakeReservationRQ()) !== false) {
    print_r($make->getResult());
} else {
    print_r($make->getLastError());
}
