<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WholeStayDiscountsLosRuleType StructType
 * @subpackage Structs
 */
class WholeStayDiscountsLosRuleType extends AbstractStructBase
{
    /**
     * The NumberOfNightsFrom
     * @var int
     */
    public $NumberOfNightsFrom;
    /**
     * The NumberOfNightsTo
     * @var int
     */
    public $NumberOfNightsTo;
    /**
     * The AdjustmentType
     * @var string
     */
    public $AdjustmentType;
    /**
     * The Value
     * @var float
     */
    public $Value;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for WholeStayDiscountsLosRuleType
     * @uses WholeStayDiscountsLosRuleType::setNumberOfNightsFrom()
     * @uses WholeStayDiscountsLosRuleType::setNumberOfNightsTo()
     * @uses WholeStayDiscountsLosRuleType::setAdjustmentType()
     * @uses WholeStayDiscountsLosRuleType::setValue()
     * @uses WholeStayDiscountsLosRuleType::setRatePlanCode()
     * @param int $numberOfNightsFrom
     * @param int $numberOfNightsTo
     * @param string $adjustmentType
     * @param float $value
     * @param string $ratePlanCode
     */
    public function __construct($numberOfNightsFrom = null, $numberOfNightsTo = null, $adjustmentType = null, $value = null, $ratePlanCode = null)
    {
        $this
            ->setNumberOfNightsFrom($numberOfNightsFrom)
            ->setNumberOfNightsTo($numberOfNightsTo)
            ->setAdjustmentType($adjustmentType)
            ->setValue($value)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get NumberOfNightsFrom value
     * @return int|null
     */
    public function getNumberOfNightsFrom()
    {
        return $this->NumberOfNightsFrom;
    }
    /**
     * Set NumberOfNightsFrom value
     * @param int $numberOfNightsFrom
     * @return \room\StructType\WholeStayDiscountsLosRuleType
     */
    public function setNumberOfNightsFrom($numberOfNightsFrom = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfNightsFrom) && !(is_int($numberOfNightsFrom) || ctype_digit($numberOfNightsFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfNightsFrom, true), gettype($numberOfNightsFrom)), __LINE__);
        }
        $this->NumberOfNightsFrom = $numberOfNightsFrom;
        return $this;
    }
    /**
     * Get NumberOfNightsTo value
     * @return int|null
     */
    public function getNumberOfNightsTo()
    {
        return $this->NumberOfNightsTo;
    }
    /**
     * Set NumberOfNightsTo value
     * @param int $numberOfNightsTo
     * @return \room\StructType\WholeStayDiscountsLosRuleType
     */
    public function setNumberOfNightsTo($numberOfNightsTo = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfNightsTo) && !(is_int($numberOfNightsTo) || ctype_digit($numberOfNightsTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfNightsTo, true), gettype($numberOfNightsTo)), __LINE__);
        }
        $this->NumberOfNightsTo = $numberOfNightsTo;
        return $this;
    }
    /**
     * Get AdjustmentType value
     * @return string|null
     */
    public function getAdjustmentType()
    {
        return $this->AdjustmentType;
    }
    /**
     * Set AdjustmentType value
     * @param string $adjustmentType
     * @return \room\StructType\WholeStayDiscountsLosRuleType
     */
    public function setAdjustmentType($adjustmentType = null)
    {
        // validation for constraint: string
        if (!is_null($adjustmentType) && !is_string($adjustmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adjustmentType, true), gettype($adjustmentType)), __LINE__);
        }
        $this->AdjustmentType = $adjustmentType;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \room\StructType\WholeStayDiscountsLosRuleType
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \room\StructType\WholeStayDiscountsLosRuleType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\WholeStayDiscountsLosRuleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
