<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RulesType StructType
 * @subpackage Structs
 */
class RulesType extends AbstractStructBase
{
    /**
     * The CheckIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CheckIn;
    /**
     * The CheckInText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DescriptionType
     */
    public $CheckInText;
    /**
     * The CheckOut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CheckOut;
    /**
     * The CheckOutText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DescriptionType
     */
    public $CheckOutText;
    /**
     * The TermsAndConditions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TermsAndConditions;
    /**
     * The CancellationPolicies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\CancellationPoliciesType
     */
    public $CancellationPolicies;
    /**
     * The Pets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DescriptionType
     */
    public $Pets;
    /**
     * The DefaultEmailOptIn
     * @var bool
     */
    public $DefaultEmailOptIn;
    /**
     * Constructor method for RulesType
     * @uses RulesType::setCheckIn()
     * @uses RulesType::setCheckInText()
     * @uses RulesType::setCheckOut()
     * @uses RulesType::setCheckOutText()
     * @uses RulesType::setTermsAndConditions()
     * @uses RulesType::setCancellationPolicies()
     * @uses RulesType::setPets()
     * @uses RulesType::setDefaultEmailOptIn()
     * @param string $checkIn
     * @param \room\StructType\DescriptionType $checkInText
     * @param string $checkOut
     * @param \room\StructType\DescriptionType $checkOutText
     * @param string $termsAndConditions
     * @param \room\StructType\CancellationPoliciesType $cancellationPolicies
     * @param \room\StructType\DescriptionType $pets
     * @param bool $defaultEmailOptIn
     */
    public function __construct($checkIn = null, \room\StructType\DescriptionType $checkInText = null, $checkOut = null, \room\StructType\DescriptionType $checkOutText = null, $termsAndConditions = null, \room\StructType\CancellationPoliciesType $cancellationPolicies = null, \room\StructType\DescriptionType $pets = null, $defaultEmailOptIn = null)
    {
        $this
            ->setCheckIn($checkIn)
            ->setCheckInText($checkInText)
            ->setCheckOut($checkOut)
            ->setCheckOutText($checkOutText)
            ->setTermsAndConditions($termsAndConditions)
            ->setCancellationPolicies($cancellationPolicies)
            ->setPets($pets)
            ->setDefaultEmailOptIn($defaultEmailOptIn);
    }
    /**
     * Get CheckIn value
     * @return string|null
     */
    public function getCheckIn()
    {
        return $this->CheckIn;
    }
    /**
     * Set CheckIn value
     * @param string $checkIn
     * @return \room\StructType\RulesType
     */
    public function setCheckIn($checkIn = null)
    {
        // validation for constraint: string
        if (!is_null($checkIn) && !is_string($checkIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkIn, true), gettype($checkIn)), __LINE__);
        }
        $this->CheckIn = $checkIn;
        return $this;
    }
    /**
     * Get CheckInText value
     * @return \room\StructType\DescriptionType|null
     */
    public function getCheckInText()
    {
        return $this->CheckInText;
    }
    /**
     * Set CheckInText value
     * @param \room\StructType\DescriptionType $checkInText
     * @return \room\StructType\RulesType
     */
    public function setCheckInText(\room\StructType\DescriptionType $checkInText = null)
    {
        $this->CheckInText = $checkInText;
        return $this;
    }
    /**
     * Get CheckOut value
     * @return string|null
     */
    public function getCheckOut()
    {
        return $this->CheckOut;
    }
    /**
     * Set CheckOut value
     * @param string $checkOut
     * @return \room\StructType\RulesType
     */
    public function setCheckOut($checkOut = null)
    {
        // validation for constraint: string
        if (!is_null($checkOut) && !is_string($checkOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkOut, true), gettype($checkOut)), __LINE__);
        }
        $this->CheckOut = $checkOut;
        return $this;
    }
    /**
     * Get CheckOutText value
     * @return \room\StructType\DescriptionType|null
     */
    public function getCheckOutText()
    {
        return $this->CheckOutText;
    }
    /**
     * Set CheckOutText value
     * @param \room\StructType\DescriptionType $checkOutText
     * @return \room\StructType\RulesType
     */
    public function setCheckOutText(\room\StructType\DescriptionType $checkOutText = null)
    {
        $this->CheckOutText = $checkOutText;
        return $this;
    }
    /**
     * Get TermsAndConditions value
     * @return string|null
     */
    public function getTermsAndConditions()
    {
        return $this->TermsAndConditions;
    }
    /**
     * Set TermsAndConditions value
     * @param string $termsAndConditions
     * @return \room\StructType\RulesType
     */
    public function setTermsAndConditions($termsAndConditions = null)
    {
        // validation for constraint: string
        if (!is_null($termsAndConditions) && !is_string($termsAndConditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsAndConditions, true), gettype($termsAndConditions)), __LINE__);
        }
        $this->TermsAndConditions = $termsAndConditions;
        return $this;
    }
    /**
     * Get CancellationPolicies value
     * @return \room\StructType\CancellationPoliciesType|null
     */
    public function getCancellationPolicies()
    {
        return $this->CancellationPolicies;
    }
    /**
     * Set CancellationPolicies value
     * @param \room\StructType\CancellationPoliciesType $cancellationPolicies
     * @return \room\StructType\RulesType
     */
    public function setCancellationPolicies(\room\StructType\CancellationPoliciesType $cancellationPolicies = null)
    {
        $this->CancellationPolicies = $cancellationPolicies;
        return $this;
    }
    /**
     * Get Pets value
     * @return \room\StructType\DescriptionType|null
     */
    public function getPets()
    {
        return $this->Pets;
    }
    /**
     * Set Pets value
     * @param \room\StructType\DescriptionType $pets
     * @return \room\StructType\RulesType
     */
    public function setPets(\room\StructType\DescriptionType $pets = null)
    {
        $this->Pets = $pets;
        return $this;
    }
    /**
     * Get DefaultEmailOptIn value
     * @return bool|null
     */
    public function getDefaultEmailOptIn()
    {
        return $this->DefaultEmailOptIn;
    }
    /**
     * Set DefaultEmailOptIn value
     * @param bool $defaultEmailOptIn
     * @return \room\StructType\RulesType
     */
    public function setDefaultEmailOptIn($defaultEmailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultEmailOptIn) && !is_bool($defaultEmailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultEmailOptIn, true), gettype($defaultEmailOptIn)), __LINE__);
        }
        $this->DefaultEmailOptIn = $defaultEmailOptIn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RulesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
